/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import com.vividsolutions.jts.geom.Geometry;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import java.util.Collections;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;

public class ImmutableEnvelope
extends AbstractImmutableValidGeoObject<ImmutableEnvelope, Geometry> {
    private double miny;
    private double minx;
    private double maxx;
    private double maxy;

    protected ImmutableEnvelope(Geometry geometry, CoordinateFactory coordinateFactory) {
        super(geometry.getEnvelope(), coordinateFactory);
        com.vividsolutions.jts.geom.Coordinate[] coords = geometry.getCoordinates();
        this.minx = coords[0].x;
        this.miny = coords[0].y;
        this.maxx = coords[0].x;
        this.maxy = coords[0].y;
        for (int i = 1; i < coords.length; ++i) {
            this.minx = Math.min(this.minx, coords[i].x);
            this.miny = Math.min(this.miny, coords[i].y);
            this.maxx = Math.max(this.maxx, coords[i].x);
            this.maxy = Math.max(this.maxy, coords[i].y);
        }
    }

    public ImmutableEnvelope(Coordinate topLeft, Coordinate bottomRight) {
        this(topLeft.getX(), bottomRight.getX(), bottomRight.getY(), topLeft.getY(), ImmutableEnvelope.getCoordinateFactory(topLeft, bottomRight));
    }

    private static CoordinateFactory getCoordinateFactory(Coordinate topLeft, Coordinate bottomRight) {
        CoordinateFactory factory2;
        CoordinateFactory factory1 = topLeft.getFactory();
        if (factory1.equals(factory2 = bottomRight.getFactory())) {
            return factory1;
        }
        throw new RuntimeException("CoordinateFactory must be equal");
    }

    public ImmutableEnvelope(double left, double right, double bottom, double top, CoordinateFactory coordinateFactory) {
        this((Geometry)ImmutableGeoObjectFactory.createImmutableLineString(coordinateFactory.createCoordinate(left, bottom), coordinateFactory.createCoordinate(right, top), new Coordinate[0]).getGeometry(), coordinateFactory);
    }

    @Override
    public ImmutableEnvelope snapToGrid(double raster) {
        return this;
    }

    @Override
    public ImmutableGeoObject getTranslated(double x, double y) {
        throw new UnsupportedOperationException("cannot transform envelope");
    }

    @Override
    public List<ImmutablePoint> getCoordinates() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public ImmutablePoint getAnyPoint() {
        return ImmutableGeoObjectFactory.createImmutablePoint(this.getCoordinateFactory().createCoordinate(this.minx, this.miny));
    }

    @Override
    public double getMinX() {
        return this.minx;
    }

    @Override
    public double getMaxX() {
        return this.maxx;
    }

    @Override
    public double getMinY() {
        return this.miny;
    }

    @Override
    public double getMaxY() {
        return this.maxy;
    }

    @Override
    public boolean inBounds(double left, double right, double top, double bottom) {
        double minx = Math.min(left, right);
        double maxx = Math.max(left, right);
        double miny = Math.min(top, bottom);
        double maxy = Math.max(top, bottom);
        return minx <= this.maxx && maxx >= this.minx && miny <= this.maxy && maxy >= this.miny;
    }

    @Override
    public ImmutableEnvelope getGeom() {
        return this;
    }

    public ImmutablePoint getBottomLeft() {
        return ImmutableGeoObjectFactory.createImmutablePoint(this.getCoordinateFactory().createCoordinate(this.minx, this.miny));
    }

    public ImmutablePoint getTopRight() {
        return ImmutableGeoObjectFactory.createImmutablePoint(this.getCoordinateFactory().createCoordinate(this.maxx, this.maxy));
    }

    public ImmutablePoint getBottomRight() {
        return ImmutableGeoObjectFactory.createImmutablePoint(this.getCoordinateFactory().createCoordinate(this.maxx, this.miny));
    }

    public ImmutablePoint getTopLeft() {
        return ImmutableGeoObjectFactory.createImmutablePoint(this.getCoordinateFactory().createCoordinate(this.minx, this.maxy));
    }

    @Override
    public final ImmutableEnvelope getTransformed(CoordinateFactory coordinateFactory) {
        if (this.getCoordinateFactory() == coordinateFactory) {
            return this;
        }
        AbstractImmutableGeoObject geoObject = ImmutableGeoObjectFactory.createImmutableGeoObject(this.getGeometryClone(coordinateFactory), coordinateFactory);
        return geoObject.getEnvelope();
    }
}

