/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTWriter;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.GeomAccess;
import de.datomino.util.geo.ImmutableEnvelope;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.ktde.math.projection.CoordinateFactory;

public abstract class AbstractImmutableValidGeoObject<S extends AbstractImmutableValidGeoObject<S, T>, T extends Geometry>
extends AbstractImmutableGeoObject
implements GeomAccess<S> {
    private transient T geometry;
    private transient ImmutableEnvelope envelope;

    protected AbstractImmutableValidGeoObject(T geometry, CoordinateFactory coordinateFactory) {
        super(coordinateFactory);
        this.geometry = geometry;
    }

    protected final T getGeometry() {
        return this.geometry;
    }

    @Override
    public ImmutableGeoObject snapToGrid(double raster) {
        return this;
    }

    @Override
    public ImmutableGeoObject buffer(double distance, int quadrantSegments, int endCapStyle) {
        return ImmutableGeoObjectFactory.createImmutableGeoObject(((Geometry)this.getGeometry()).buffer(distance, quadrantSegments, endCapStyle), this.getCoordinateFactory());
    }

    @Override
    public ImmutableGeoObject buffer(double distance, int quadrantSegments) {
        return ImmutableGeoObjectFactory.createImmutableGeoObject(((Geometry)this.getGeometry()).buffer(distance, quadrantSegments), this.getCoordinateFactory());
    }

    @Override
    public ImmutableGeoObject buffer(double distance) {
        return ImmutableGeoObjectFactory.createImmutableGeoObject(((Geometry)this.getGeometry()).buffer(distance), this.getCoordinateFactory());
    }

    @Override
    public boolean contains(ImmutableGeoObject g) {
        try {
            return ((Geometry)this.getGeometry()).contains(g.getGeometryClone(this.getCoordinateFactory()));
        }
        catch (TopologyException e) {
            return false;
        }
    }

    @Override
    public ImmutableGeoObject convexHull() {
        return ImmutableGeoObjectFactory.createImmutableGeoObject(((Geometry)this.getGeometry()).convexHull(), this.getCoordinateFactory());
    }

    @Override
    public boolean coveredBy(ImmutableGeoObject g) {
        return ((Geometry)this.getGeometry()).coveredBy(g.getGeometryClone(this.getCoordinateFactory()));
    }

    @Override
    public boolean covers(ImmutableGeoObject g) {
        return ((Geometry)this.getGeometry()).covers(g.getGeometryClone(this.getCoordinateFactory()));
    }

    @Override
    public boolean crosses(ImmutableGeoObject g) {
        return ((Geometry)this.getGeometry()).crosses(g.getGeometryClone(this.getCoordinateFactory()));
    }

    @Override
    public ImmutableGeoObject difference(ImmutableGeoObject other) {
        Geometry difference = ((Geometry)this.getGeometry()).difference(other.getGeometryClone(this.getCoordinateFactory()));
        return ImmutableGeoObjectFactory.createImmutableGeoObject(difference, this.getCoordinateFactory());
    }

    @Override
    public boolean disjoint(ImmutableGeoObject g) {
        return ((Geometry)this.getGeometry()).disjoint(g.getGeometryClone(this.getCoordinateFactory()));
    }

    @Override
    public double distance(ImmutableGeoObject g) {
        return ((Geometry)this.getGeometry()).distance(g.getGeometryClone(this.getCoordinateFactory()));
    }

    @Override
    public double getArea() {
        return ((Geometry)this.getGeometry()).getArea();
    }

    @Override
    public double getLength() {
        return ((Geometry)this.getGeometry()).getLength();
    }

    @Override
    public ImmutablePoint getCentroid() {
        return (ImmutablePoint)ImmutableGeoObjectFactory.createImmutableGeoObject(((Geometry)this.getGeometry()).getCentroid(), this.getCoordinateFactory());
    }

    @Override
    public ImmutableGeoObject getTranslated(double x, double y) {
        return this.getTransformed(AffineTransform.getTranslateInstance(x, y));
    }

    @Override
    public synchronized ImmutableEnvelope getEnvelope() {
        if (this.envelope == null) {
            this.envelope = new ImmutableEnvelope(((Geometry)this.getGeometry()).getEnvelope(), this.getCoordinateFactory());
        }
        return this.envelope;
    }

    @Override
    public ImmutablePoint getInteriorPoint() {
        try {
            return (ImmutablePoint)ImmutableGeoObjectFactory.createImmutableGeoObject(((Geometry)this.getGeometry()).getInteriorPoint(), this.getCoordinateFactory());
        }
        catch (TopologyException topologyException) {
            return this.getAnyPoint();
        }
    }

    public abstract ImmutablePoint getAnyPoint();

    @Override
    public ImmutableGeoObject intersection(ImmutableGeoObject other) {
        return ImmutableGeoObjectFactory.createImmutableGeoObject(((Geometry)this.getGeometry()).intersection(other.getGeometryClone(this.getCoordinateFactory())), this.getCoordinateFactory());
    }

    @Override
    public boolean intersects(ImmutableGeoObject g) {
        return ((Geometry)this.getGeometry()).intersects(g.getGeometryClone(this.getCoordinateFactory()));
    }

    @Override
    public boolean isSimple() {
        return ((Geometry)this.getGeometry()).isSimple();
    }

    @Override
    public boolean isValid() {
        return ((Geometry)this.getGeometry()).isValid();
    }

    @Override
    public boolean overlaps(ImmutableGeoObject g) {
        return ((Geometry)this.getGeometry()).overlaps(g.getGeometryClone(this.getCoordinateFactory()));
    }

    @Override
    public boolean touches(ImmutableGeoObject g) {
        return ((Geometry)this.getGeometry()).touches(g.getGeometryClone(this.getCoordinateFactory()));
    }

    @Override
    public ImmutableGeoObject union(ImmutableGeoObject other) {
        Geometry union = ((Geometry)this.getGeometry()).union(other.getGeometryClone(this.getCoordinateFactory()));
        return ImmutableGeoObjectFactory.createImmutableGeoObject(union, this.getCoordinateFactory());
    }

    @Override
    public boolean within(ImmutableGeoObject g) {
        return ((Geometry)this.getGeometry()).within(g.getGeometryClone(this.getCoordinateFactory()));
    }

    @Override
    public final Geometry getGeometryClone(CoordinateFactory coordinateFactory) {
        Coordinate[] coordinates;
        Geometry clone = (Geometry)((Geometry)this.getGeometry()).clone();
        if (this.getCoordinateFactory().equals(coordinateFactory)) {
            return clone;
        }
        for (Coordinate coordinate : coordinates = clone.getCoordinates()) {
            coordinateFactory.transformCoordinate(coordinate, this.getCoordinateFactory());
        }
        clone.geometryChanged();
        return clone;
    }

    @Override
    public double getMinX() {
        ImmutableEnvelope envelope = this.getEnvelope();
        return envelope.getMinX();
    }

    @Override
    public double getMaxX() {
        ImmutableEnvelope envelope = this.getEnvelope();
        return envelope.getMaxX();
    }

    @Override
    public double getMinY() {
        ImmutableEnvelope envelope = this.getEnvelope();
        return envelope.getMinY();
    }

    @Override
    public double getMaxY() {
        ImmutableEnvelope envelope = this.getEnvelope();
        return envelope.getMaxY();
    }

    @Override
    public boolean inBounds(double left, double right, double top, double bottom) {
        ImmutableEnvelope envelope = this.getEnvelope();
        return envelope.inBounds(left, right, top, bottom);
    }

    @Override
    public S getGeom() {
        return (S)this;
    }

    @Override
    public byte[] getWkb() {
        return new WKBWriter().write((Geometry)this.getGeometry());
    }

    @Override
    public String getWkt() {
        return new WKTWriter().write((Geometry)this.getGeometry());
    }

    public S getTransformed(CoordinateFactory coordinateFactory) {
        if (this.getCoordinateFactory() == coordinateFactory) {
            return (S)this;
        }
        return (S)((AbstractImmutableValidGeoObject)ImmutableGeoObjectFactory.createImmutableGeoObject(this.getGeometryClone(coordinateFactory), coordinateFactory));
    }

    @Override
    public final ImmutableGeoObject getTransformed(AffineTransform saveTransform) {
        Geometry clone = (Geometry)((Geometry)this.getGeometry()).clone();
        Coordinate[] coordinates = clone.getCoordinates();
        Point2D.Double point = new Point2D.Double();
        Point2D dst = new Point2D.Double();
        for (Coordinate coordinate : coordinates) {
            ((Point2D)point).setLocation(coordinate.x, coordinate.y);
            dst = saveTransform.transform(point, dst);
            coordinate.x = dst.getX();
            coordinate.y = dst.getY();
        }
        clone.geometryChanged();
        return ImmutableGeoObjectFactory.createImmutableGeoObject(clone, this.getCoordinateFactory());
    }

    @Override
    public IntersectionMatrix relate(ImmutableGeoObject other) {
        return ((Geometry)this.getGeometry()).relate(other.getGeometryClone(this.getCoordinateFactory()));
    }

    public synchronized void clearEnvelope() {
        this.envelope = null;
    }
}

