/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.format;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.apache.commons.lang.StringUtils;

public class SpecialNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = -4171197000788923395L;
    private boolean thousandPoint;
    private Integer decimalPlaces;

    public SpecialNumberFormat(boolean thousandPoint, Integer decimalPlaces) {
        this.thousandPoint = thousandPoint;
        this.decimalPlaces = decimalPlaces;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        String s;
        int cIndex;
        double d = number;
        if (this.decimalPlaces != null) {
            double pow = Math.pow(10.0, this.decimalPlaces.intValue());
            d *= pow;
            d = Math.round(d);
            d /= pow;
        }
        String full = (cIndex = (s = Double.toString(d)).indexOf(46)) < 0 ? s : s.substring(0, cIndex);
        String dec = cIndex < 0 ? "" : s.substring(cIndex + 1);
        return toAppendTo.append(this.format(full, dec));
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.format(Long.toString(number), ""));
    }

    private String format(String full, String dec) {
        String s;
        StringBuilder sb = new StringBuilder();
        if (this.thousandPoint) {
            s = "";
            int j = 0;
            for (int i = full.length() - 1; i >= 0; --i) {
                if (j > 0 && j % 3 == 0) {
                    s = '.' + s;
                }
                s = full.charAt(i) + s;
                ++j;
            }
            sb.append(s);
        } else {
            sb.append(full);
        }
        if (this.decimalPlaces != null) {
            sb.append(',');
            s = dec.length() > this.decimalPlaces ? dec.substring(0, this.decimalPlaces) : StringUtils.rightPad(dec, (int)this.decimalPlaces, '0');
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        String mod = source.replace(".", "").trim();
        parsePosition.setIndex(1);
        if (mod.matches("\\d+(,\\d*)?")) {
            int cIndex = mod.indexOf(44);
            if (cIndex < 0) {
                return Integer.valueOf(mod);
            }
            return Double.valueOf(mod.replace(',', '.'));
        }
        return null;
    }
}

