/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.csv;

import de.datomino.util.csv.CsvInvalidMappingException;
import de.datomino.util.csv.CsvParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.util.XmlUtils;
import org.ktde.util.datatypes.Tupel;
import org.ktde.util.io.CsvReader;

public final class CsvUtils {
    public static String transformToXml(InputStream csv, String encoding, Map<String, Set<String>> headerMapping, Character separator, Character text) throws IOException, CsvInvalidMappingException, CsvParseException {
        CsvReader csvReader = new CsvReader(csv, encoding);
        return CsvUtils.transformToXml(csvReader, headerMapping, separator, text);
    }

    public static String transformToXml(Reader reader, Map<String, Set<String>> mapping, Character separator, Character text) throws IOException, CsvInvalidMappingException, CsvParseException {
        CsvReader csvReader = new CsvReader(new BufferedReader(reader));
        return CsvUtils.transformToXml(csvReader, mapping, separator, text);
    }

    private static String transformToXml(CsvReader csvReader, Map<String, Set<String>> headerMapping, Character delim, Character text) throws IOException, CsvInvalidMappingException, CsvParseException {
        if (delim != null) {
            csvReader.setDelim(delim);
        }
        if (text != null) {
            csvReader.setText(text);
        }
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<csv>\n");
        List<String> headLine = csvReader.readLine();
        if (headLine != null) {
            int columnCount = 0;
            ArrayList<Tupel<Integer, String>> indexTagList = new ArrayList<Tupel<Integer, String>>(headerMapping.size());
            HashSet<String> unusedTags = new HashSet<String>();
            for (Set<String> tags : headerMapping.values()) {
                unusedTags.addAll(tags);
            }
            for (String header : headLine) {
                Set<String> tags = headerMapping.get(header);
                if (tags != null) {
                    for (String tag : tags) {
                        indexTagList.add(new Tupel<Integer, String>(columnCount, tag));
                    }
                    unusedTags.removeAll(tags);
                }
                ++columnCount;
            }
            if (!unusedTags.isEmpty()) {
                csvReader.close();
                throw new CsvInvalidMappingException(unusedTags);
            }
            List<String> line = csvReader.readLine();
            int rowIndex = 2;
            while (line != null) {
                if (!line.isEmpty() && !line.get(0).isEmpty()) {
                    sb.append("\t<row line=\"").append(rowIndex).append("\">\n");
                    for (Tupel tupel : indexTagList) {
                        try {
                            String value = line.get((Integer)tupel.getElement1());
                            String tag = (String)tupel.getElement2();
                            sb.append("\t\t<").append(tag).append(">").append(XmlUtils.escapeXml(value)).append("</").append(tag).append(">\n");
                        }
                        catch (IndexOutOfBoundsException ex) {
                            csvReader.close();
                            throw new CsvParseException(rowIndex);
                        }
                    }
                    sb.append("\t</row>\n");
                }
                line = csvReader.readLine();
                ++rowIndex;
            }
        }
        sb.append("</csv>\n");
        csvReader.close();
        return sb.toString();
    }
}

