/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.csv;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ktde.util.StringUtil;
import org.ktde.util.io.CsvReader;

public class CsvLineReader {
    private Map<Object, Integer> columnIndexMapping;
    private CsvReader reader;

    public CsvLineReader(CsvReader reader, Map<? extends Object, String> columnMapping) throws IOException {
        this.reader = reader;
        this.columnIndexMapping = new LinkedHashMap<Object, Integer>();
        Map<String, Integer> headerMapping = CsvReader.getHeaderMapping(reader.readLine());
        for (Map.Entry<? extends Object, String> entry : columnMapping.entrySet()) {
            Integer i;
            String value = entry.getValue();
            if (value == null || (i = headerMapping.get(value)) == null) continue;
            Object key = entry.getKey();
            this.columnIndexMapping.put(key, i);
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Map<Object, String> readLine() throws IOException {
        return this.readLine(new LinkedHashMap<Object, String>());
    }

    public Map<Object, String> readLine(Map<Object, String> store) throws IOException {
        List<String> line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        if (store == null) {
            store = new LinkedHashMap<Object, String>();
        }
        for (Map.Entry<Object, Integer> entry : this.columnIndexMapping.entrySet()) {
            Integer i = entry.getValue();
            if (line.size() <= i) continue;
            store.put(entry.getKey(), line.get(i));
        }
        return store;
    }

    public boolean containsColumn(Object column) {
        return this.columnIndexMapping.containsKey(column);
    }

    public static boolean isLineEmpty(Map<Object, String> line) {
        for (String value : line.values()) {
            if (StringUtil.isBlank(value)) continue;
            return false;
        }
        return true;
    }
}

