/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.crypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import org.apache.commons.io.FileUtils;
import org.ktde.util.datatypes.Tupel;

public final class CryptUtil {
    private static final int IN_BLOCK_SIZE = 117;
    private static final int OUT_BLOCK_SIZE = 128;

    public static byte[] encrypt(byte[] in, PublicKey publicKey) throws NoSuchAlgorithmException, GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(1, publicKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < in.length; i += 117) {
            int length = Math.min(117, in.length - i);
            byte[] part = new byte[length];
            System.arraycopy(in, i, part, 0, length);
            part = cipher.doFinal(part);
            try {
                baos.write(part);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return baos.toByteArray();
    }

    public static byte[] decrypt(byte[] in, PrivateKey privateKey) throws NoSuchAlgorithmException, GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(2, privateKey);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(in);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] part = new byte[128];
            int i = bais.read(part);
            while (i >= 0) {
                if (i < 128) {
                    byte[] rPart = new byte[i];
                    System.arraycopy(part, 0, rPart, 0, i);
                    part = rPart;
                }
                byte[] out = cipher.doFinal(part);
                baos.write(out);
                i = bais.read(part);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Tupel<byte[], byte[]> generateKeys(String algorithm) throws NoSuchAlgorithmException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
            keyGen.initialize(1024);
            KeyPair key = keyGen.generateKeyPair();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream publicKeyOS = new ObjectOutputStream(baos);
            publicKeyOS.writeObject(key.getPublic());
            publicKeyOS.flush();
            publicKeyOS.close();
            byte[] pub = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            ObjectOutputStream privateKeyOS = new ObjectOutputStream(baos);
            privateKeyOS.writeObject(key.getPrivate());
            privateKeyOS.flush();
            privateKeyOS.close();
            byte[] priv = baos.toByteArray();
            return new Tupel<byte[], byte[]>(pub, priv);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void generateKeys(String algorithm, File pub, File priv) throws NoSuchAlgorithmException, IOException {
        Tupel<byte[], byte[]> tupel = CryptUtil.generateKeys(algorithm);
        FileUtils.writeByteArrayToFile(pub, tupel.getElement1());
        FileUtils.writeByteArrayToFile(priv, tupel.getElement2());
    }

    public static PublicKey readPublicKeyFromFile(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        return CryptUtil.readPublicKeyFromInputStream(new FileInputStream(file));
    }

    public static PublicKey readPublicKeyFromInputStream(InputStream input) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(input);
        PublicKey pub = (PublicKey)in.readObject();
        in.close();
        return pub;
    }

    public static PrivateKey readPrivateKeyFromFile(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        return CryptUtil.readPrivateKeyFromInputStream(new FileInputStream(file));
    }

    public static PrivateKey readPrivateKeyFromInputStream(InputStream input) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(input);
        PrivateKey priv = (PrivateKey)in.readObject();
        in.close();
        return priv;
    }
}

