/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.convertor;

import de.datomino.util.convertor.Format;
import java.util.ArrayList;
import org.springframework.util.StringUtils;

public class CamelCaseFormat
implements Format {
    @Override
    public String toFormattedString(String[] parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(StringUtils.capitalize(part.toLowerCase()));
        }
        return sb.toString();
    }

    @Override
    public String[] toParts(String string) {
        ArrayList<String> parts = new ArrayList<String>();
        int length = string.length();
        boolean upperCaseMode = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && !upperCaseMode) {
                if (sb.length() > 0) {
                    parts.add(sb.toString());
                    sb = new StringBuilder();
                }
                upperCaseMode = true;
            } else {
                upperCaseMode = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        if (sb.length() > 0) {
            parts.add(sb.toString());
        }
        return (String[])parts.toArray();
    }
}

