/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.comparator;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ComparatorBuilder {
    private List<Comparable<?>> comparables1 = new LinkedList();
    private List<Comparable<?>> comparables2 = new LinkedList();
    private List<Boolean> nullHigh = new LinkedList<Boolean>();

    public <T extends Comparable<T>> ComparatorBuilder append(Comparable<T> c1, Comparable<T> c2) {
        return this.append(c1, c2, false);
    }

    public <T extends Comparable<T>> ComparatorBuilder append(Comparable<T> c1, Comparable<T> c2, boolean nullHigh) {
        this.comparables1.add(c1);
        this.comparables2.add(c2);
        this.nullHigh.add(nullHigh);
        return this;
    }

    public int compare() {
        Iterator<Comparable<?>> iter1 = this.comparables1.iterator();
        Iterator<Comparable<?>> iter2 = this.comparables2.iterator();
        Iterator<Boolean> nIter = this.nullHigh.iterator();
        while (iter1.hasNext()) {
            Comparable<?> c1 = iter1.next();
            Comparable<?> c2 = iter2.next();
            Boolean nullHigh = nIter.next();
            if (c1 == c2) continue;
            if (c1 == null) {
                return nullHigh != false ? -1 : 1;
            }
            if (c2 == null) {
                return nullHigh != false ? 1 : -1;
            }
            int d = c1.compareTo(c2);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }
}

