/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.comparator;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractNumericalComparator<T>
implements Comparator<T> {
    private static final Pattern PATTERN = Pattern.compile("([0-9]*)(.*)");

    @Override
    public int compare(T t1, T t2) {
        Tupel<Long, String> tupel1 = this.getCompareParts(t1, Long.MAX_VALUE);
        Tupel<Long, String> tupel2 = this.getCompareParts(t2, Long.MAX_VALUE);
        int d = tupel1.getElement1().compareTo(tupel2.getElement1());
        return d == 0 ? tupel1.getElement2().compareTo(tupel2.getElement2()) : d;
    }

    protected abstract String getCompareValue(T var1);

    protected Tupel<Long, String> getCompareParts(T t, Long valueIfEmpty) {
        Matcher matcher = PATTERN.matcher(this.getCompareValue(t));
        matcher.matches();
        String number = matcher.group(1);
        Long longValue = number.isEmpty() ? valueIfEmpty : Long.valueOf(number);
        return new Tupel<Long, String>(longValue, matcher.group(2));
    }
}

