/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.command.shp;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import de.datomino.util.geo.ImmutableGeoObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.ktde.util.datatypes.Tupel;

public class WkbToShp {
    public static void main(String[] args) throws IOException, ParseException {
        String prefix = args[0];
        WkbToShp.wkbToShp(prefix, System.in);
    }

    public static void wkbToShp(String prefix, InputStream in) throws IOException, ParseException, FileNotFoundException, ShapefileException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = br.readLine();
        LinkedList<Geometry> geoms = new LinkedList<Geometry>();
        while (line != null) {
            if (!line.isEmpty()) {
                Geometry geometry = new WKBReader().read(WKBReader.hexToBytes(line));
                geoms.add(geometry);
            }
            line = br.readLine();
        }
        br.close();
        WkbToShp.toShpFile(prefix, geoms);
    }

    public static Tupel<File, File> geomsToShp(String prefix, List<? extends ImmutableGeoObject> geoObjects) throws ShapefileException, FileNotFoundException, IOException {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>(geoObjects.size());
        GeometryFactory factory = new GeometryFactory();
        for (ImmutableGeoObject immutableGeoObject : geoObjects) {
            Geometry geometryClone = immutableGeoObject.getGeometryClone(immutableGeoObject.getCoordinateFactory());
            if (geometryClone == null) continue;
            geoms.add(geometryClone);
        }
        return WkbToShp.toShpFile(prefix, geoms);
    }

    private static Tupel<File, File> toShpFile(String prefix, List<Geometry> geoms) throws FileNotFoundException, IOException, ShapefileException {
        ShapeType shapeType = geoms.isEmpty() ? ShapeType.NULL : null;
        for (Geometry geometry : geoms) {
            shapeType = WkbToShp.determineShapeType(shapeType, geometry);
        }
        if (shapeType == null) {
            shapeType = ShapeType.NULL;
        }
        Geometry[] array = new Geometry[geoms.size()];
        array = geoms.toArray(array);
        String shapeFileName = prefix + ".shp";
        RandomAccessFile shp = new RandomAccessFile(shapeFileName, "rw");
        String shxFileName = prefix + ".shx";
        RandomAccessFile shx = new RandomAccessFile(shxFileName, "rw");
        ShapefileWriter shapefileWriter = new ShapefileWriter(shp.getChannel(), shx.getChannel());
        shapefileWriter.write(new GeometryCollection(array, new GeometryFactory()), shapeType);
        shapefileWriter.close();
        return new Tupel<File, File>(new File(shapeFileName), new File(shxFileName));
    }

    private static ShapeType determineShapeType(ShapeType shapeType, Geometry geometry) {
        if (geometry instanceof Point) {
            if (shapeType == null) {
                shapeType = ShapeType.POINT;
            } else if (shapeType != ShapeType.POINT) {
                throw new RuntimeException();
            }
        } else if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            if (shapeType == null) {
                shapeType = ShapeType.ARC;
            } else if (shapeType != ShapeType.ARC) {
                throw new RuntimeException();
            }
        } else if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            if (shapeType == null) {
                shapeType = ShapeType.POLYGON;
            } else if (shapeType != ShapeType.POLYGON) {
                throw new RuntimeException();
            }
        }
        return shapeType;
    }
}

