/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.command;

import de.datomino.util.command.AttributeDescriptor;
import de.datomino.util.command.Type;
import de.datomino.util.command.shp.ShpToWkb;
import de.datomino.util.geo.ImmutableGeoObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.DateField;
import org.xBaseJ.fields.Field;
import org.xBaseJ.fields.FloatField;
import org.xBaseJ.fields.LogicalField;
import org.xBaseJ.fields.MemoField;
import org.xBaseJ.fields.NumField;
import org.xBaseJ.fields.PictureField;
import org.xBaseJ.xBaseJException;

public class ShpDbfReader {
    public static AttributeDescriptor[] getDbfHeader(String prefix, String encodedType) throws xBaseJException, IOException {
        File file = new File(prefix + ".dbf");
        DBF dbf = new DBF(file.getCanonicalPath(), StringUtil.isBlank(encodedType) ? "8859_1" : encodedType.trim());
        Tupel<AttributeDescriptor[], Field[]> tupel = ShpDbfReader.getHeader(dbf);
        dbf.close();
        return tupel.getElement1();
    }

    public static Tupel<AttributeDescriptor[], List<Tupel<Object[], ImmutableGeoObject>>> readDbf(String prefix, CoordinateFactory coordinateFactory, String encodedType) throws xBaseJException, IOException {
        File file = new File(prefix + ".dbf");
        DBF dbf = new DBF(file.getCanonicalPath(), StringUtil.isBlank(encodedType) ? "8859_1" : encodedType.trim());
        Tupel<AttributeDescriptor[], Field[]> tupel = ShpDbfReader.getHeader(dbf);
        AttributeDescriptor[] attributeDescriptors = tupel.getElement1();
        Field[] fields = tupel.getElement2();
        int fieldCount = dbf.getFieldCount();
        int recordCount = dbf.getRecordCount();
        ArrayList<Tupel<Object[], ImmutableGeoObject>> list = new ArrayList<Tupel<Object[], ImmutableGeoObject>>(recordCount);
        List<ImmutableGeoObject> geoms = ShpToWkb.shpToImmutableGeoObjects(prefix + ".shp", coordinateFactory);
        Iterator<ImmutableGeoObject> iter = geoms.iterator();
        for (int j = 0; j < recordCount; ++j) {
            dbf.read();
            ImmutableGeoObject geom = iter.next();
            Object[] row = new Object[fieldCount];
            block16: for (int i = 0; i < fieldCount; ++i) {
                AttributeDescriptor attributeDescriptor = attributeDescriptors[i];
                Field field = fields[i];
                switch (attributeDescriptor.getType()) {
                    case CHAR: {
                        row[i] = field.get();
                        continue block16;
                    }
                    case DATE: {
                        Calendar cal = null;
                        try {
                            cal = ((DateField)field).getCalendar();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (cal == null) continue block16;
                        row[i] = cal.getTime();
                        continue block16;
                    }
                    case FLOAT: {
                        String f = field.get();
                        if (f == null) continue block16;
                        try {
                            row[i] = Float.valueOf(f);
                        }
                        catch (Exception exception) {}
                        continue block16;
                    }
                    case LOGICAL: {
                        row[i] = ((LogicalField)field).getBoolean();
                        continue block16;
                    }
                    case MEMO: {
                        row[i] = field.get();
                        continue block16;
                    }
                    case NUM: {
                        String l = field.get();
                        if (l == null) continue block16;
                        try {
                            Double d = Double.valueOf(l);
                            row[i] = d;
                        }
                        catch (Exception exception) {}
                        continue block16;
                    }
                    case PICTURE: {
                        row[i] = ((PictureField)field).getBytes();
                    }
                }
            }
            list.add(new Tupel<Object[], ImmutableGeoObject>(row, geom));
        }
        dbf.close();
        return new Tupel<AttributeDescriptor[], List<Tupel<Object[], ImmutableGeoObject>>>(attributeDescriptors, list);
    }

    private static Tupel<AttributeDescriptor[], Field[]> getHeader(DBF dbf) throws xBaseJException {
        int fieldCount = dbf.getFieldCount();
        Field[] fields = new Field[fieldCount];
        AttributeDescriptor[] attributeDescriptors = new AttributeDescriptor[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = dbf.getField(i + 1);
            AttributeDescriptor attributeDescriptor = null;
            if (fields[i] instanceof CharField) {
                attributeDescriptor = new AttributeDescriptor(fields[i].getName(), Type.CHAR);
            } else if (fields[i] instanceof DateField) {
                attributeDescriptor = new AttributeDescriptor(fields[i].getName(), Type.DATE);
            } else if (fields[i] instanceof LogicalField) {
                attributeDescriptor = new AttributeDescriptor(fields[i].getName(), Type.LOGICAL);
            } else if (fields[i] instanceof MemoField) {
                attributeDescriptor = new AttributeDescriptor(fields[i].getName(), Type.MEMO);
            } else if (fields[i] instanceof FloatField) {
                attributeDescriptor = new AttributeDescriptor(fields[i].getName(), Type.FLOAT);
            } else if (fields[i] instanceof NumField) {
                attributeDescriptor = new AttributeDescriptor(fields[i].getName(), Type.NUM);
            } else if (fields[i] instanceof PictureField) {
                attributeDescriptor = new AttributeDescriptor(fields[i].getName(), Type.PICTURE);
            }
            attributeDescriptors[i] = attributeDescriptor;
        }
        return new Tupel<AttributeDescriptor[], Field[]>(attributeDescriptors, fields);
    }
}

