/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.collection;

import java.util.HashMap;
import java.util.Map;

public class HashMapBuilder<T, U> {
    private Map<T, U> map = new HashMap<T, U>();

    public HashMapBuilder<T, U> append(T key, U value) {
        this.map.put(key, value);
        return this;
    }

    public HashMapBuilder<T, U> append(KeyValuePair<T, U> keyValuePair) {
        return this.append(((KeyValuePair)keyValuePair).key, ((KeyValuePair)keyValuePair).value);
    }

    public Map<T, U> getMap() {
        return this.map;
    }

    public static <V, W> Map<V, W> createMap(KeyValuePair<V, W> ... keyValuePairs) {
        HashMapBuilder<V, W> hashMapBuilder = new HashMapBuilder<V, W>();
        for (KeyValuePair<V, W> keyValuePair : keyValuePairs) {
            hashMapBuilder.append(keyValuePair);
        }
        return hashMapBuilder.getMap();
    }

    public static <V, W> KeyValuePair<V, W> with(V key, W value) {
        return new KeyValuePair<V, W>(key, value);
    }

    public static class KeyValuePair<V, W> {
        private V key;
        private W value;

        public KeyValuePair(V key, W value) {
            this.key = key;
            this.value = value;
        }
    }
}

