/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.collection;

import java.util.ListIterator;

public class ArrayIterator<T>
implements ListIterator<T> {
    private T[] array;
    private int currentIndex = 0;

    public ArrayIterator(T[] array) {
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.array.length;
    }

    @Override
    public T next() {
        T v = this.array[this.currentIndex];
        ++this.currentIndex;
        return v;
    }

    @Override
    public boolean hasPrevious() {
        return this.array.length > 0 && this.currentIndex > 1;
    }

    @Override
    public T previous() {
        int previousIndex = this.currentIndex - 2;
        T v = this.array[previousIndex];
        --this.currentIndex;
        return v;
    }

    @Override
    public int nextIndex() {
        return this.currentIndex;
    }

    @Override
    public int previousIndex() {
        return Math.max(-1, this.currentIndex - 2);
    }

    @Override
    public void remove() {
        throw new RuntimeException();
    }

    @Override
    public void set(T e) {
        this.array[this.currentIndex - 1] = e;
    }

    @Override
    public void add(T e) {
        throw new RuntimeException();
    }
}

