/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.model;

import de.datomino.util.assistant.model.Field;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.callback.CallBack;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class Page {
    private String title;
    private List<Fieldset> fieldsets;
    private LinkedList<CallBack<Boolean, Window>> leaveActions;
    private Fieldset anonymous;
    private Component additionalComponent;

    public Page(String title) {
        this.title = title;
        this.fieldsets = new LinkedList<Fieldset>();
        this.leaveActions = new LinkedList();
    }

    public Page(String title, List<Field<?>> fields) {
        this.title = title;
        this.fieldsets = new LinkedList<Fieldset>();
        this.anonymous = new Fieldset(null, fields);
        this.fieldsets.add(this.anonymous);
        this.leaveActions = new LinkedList();
    }

    public void addField(Field<?> field) {
        if (this.anonymous == null) {
            this.anonymous = new Fieldset(null);
            this.fieldsets.add(this.anonymous);
        }
        this.anonymous.addField(field);
    }

    public void addFieldset(Fieldset fieldset) {
        if (fieldset.isAnonymous()) {
            if (this.anonymous == null) {
                this.anonymous = fieldset;
                this.fieldsets.add(fieldset);
            }
        } else {
            this.anonymous = null;
            this.fieldsets.add(fieldset);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public List<Fieldset> getFieldsets() {
        return Collections.unmodifiableList(this.fieldsets);
    }

    public Collection<Field<?>> getFields() {
        LinkedHashSet set = new LinkedHashSet();
        for (Fieldset fieldset : this.fieldsets) {
            set.addAll(fieldset.getFields());
        }
        return Collections.unmodifiableSet(set);
    }

    public void addLeaveAction(CallBack<Boolean, Window> action) {
        this.leaveActions.add(action);
    }

    public List<CallBack<Boolean, Window>> getLeaveActions() {
        return Collections.unmodifiableList(this.leaveActions);
    }

    public Component getAdditionalComponent() {
        return this.additionalComponent;
    }

    public void setAdditionalComponent(Component additionalComponent) {
        this.additionalComponent = additionalComponent;
    }
}

