/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.model;

import de.datomino.util.assistant.model.FileField;
import de.datomino.util.assistant.model.StringField;
import de.datomino.util.message.MessageResolver;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.swing.AbstractAction;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.StringUtil;

public class CsvContentGuesser
extends AbstractAction {
    private static final long serialVersionUID = -3617220554468651051L;
    private StringField encodingField;
    private StringField delimiterField;
    private StringField textQuoteField;
    private FileField fileField;
    private File file;
    private String encodingGuess;
    private Character delimiterGuess;
    private Character textQuoteGuess;

    public CsvContentGuesser(FileField fileField, StringField encodingField, StringField delimiterField, StringField textQuoteField, MessageResolver messageResolver) {
        super(messageResolver.resolveMessage("buttons.guess", new Serializable[0]));
        this.fileField = fileField;
        this.encodingField = encodingField;
        this.delimiterField = delimiterField;
        this.textQuoteField = textQuoteField;
        this.setEnabledState();
        this.fileField.addValueChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent e) {
                CsvContentGuesser.this.setEnabledState();
            }
        });
    }

    private void setEnabledState() {
        this.file = (File)this.fileField.getValue();
        this.setEnabled(this.file != null && this.file.isFile());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.file != null) {
            boolean foundIso = false;
            boolean foundUtf8 = false;
            try {
                int index;
                FileInputStream fis = new FileInputStream(this.file);
                byte[] b = new byte[10000];
                int read = fis.read(b);
                fis.close();
                char[] delims = new char[]{',', ';', '|'};
                char[] quotes = new char[]{'\"', '\''};
                String s = null;
                char[] special = new char[]{'\u00e4', '\u00f6', '\u00fc', '\u00c4', '\u00d6', '\u00dc', '\u00df'};
                String enc = new String(b, 0, read, "UTF-8");
                for (char c : special) {
                    if (enc.indexOf(c) < 0) continue;
                    s = enc;
                    this.encodingGuess = "UTF-8";
                    break;
                }
                if (s == null) {
                    enc = new String(b, 0, read, "ISO-8859-1");
                    for (char c : special) {
                        if (enc.indexOf(c) < 0) continue;
                        s = enc;
                        this.encodingGuess = "ISO-8859-1";
                        break;
                    }
                }
                if (s == null) {
                    enc = new String(b, 0, read, "Cp1252");
                    for (char c : special) {
                        if (enc.indexOf(c) < 0) continue;
                        s = enc;
                        this.encodingGuess = "Cp1252";
                        break;
                    }
                }
                if (s == null) {
                    s = new String(b, 0, read, Charset.defaultCharset());
                    this.encodingGuess = Charset.defaultCharset().name();
                }
                Integer minIndex = null;
                for (char c : quotes) {
                    index = s.indexOf(c);
                    if (index < 0 || minIndex != null && index >= minIndex) continue;
                    this.textQuoteGuess = Character.valueOf(c);
                    minIndex = index;
                }
                minIndex = null;
                for (char c : delims) {
                    index = s.indexOf(c);
                    if (index < 0 || minIndex != null && index >= minIndex) continue;
                    this.delimiterGuess = Character.valueOf(c);
                    minIndex = index;
                }
                if (this.delimiterGuess == null) {
                    this.delimiterGuess = Character.valueOf(';');
                }
                if (this.textQuoteGuess == null) {
                    this.textQuoteGuess = Character.valueOf('\"');
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file = null;
        }
        this.delimiterField.setValue(String.valueOf(this.delimiterGuess));
        this.textQuoteField.setValue(String.valueOf(this.textQuoteGuess));
        this.encodingField.setValue(this.encodingGuess);
    }

    public File getFile() {
        return (File)this.fileField.getValue();
    }

    public String getEncoding() {
        return (String)this.encodingField.getValue();
    }

    public char getDelim() {
        String s = (String)this.delimiterField.getValue();
        if (StringUtil.isEmpty(s) || s.length() > 1) {
            throw new RuntimeException("Csv Trennzeichen muss genau ein Zeichen sein");
        }
        return s.charAt(0);
    }

    public char getTextQuote() {
        String s = (String)this.textQuoteField.getValue();
        if (StringUtil.isEmpty(s)) {
            return '\u0000';
        }
        if (s.length() > 1) {
            throw new RuntimeException("Csv Textmaske muss genau ein Zeichen sein");
        }
        return s.charAt(0);
    }

    public static void main(String[] args) throws UnsupportedEncodingException, IOException {
        String s = "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(s.getBytes("UTF-8"));
        byte[] b = baos.toByteArray();
        char[] iso15s = new char[]{'\u00a4'};
        char[] utfs = new char[]{'\u00c3', '\u201a', '\u00ac'};
        System.out.println('\u00a4');
    }
}

