/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.model;

import de.datomino.util.assistant.editor.Editor;
import de.datomino.util.assistant.model.Field;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;

public abstract class AbstractField<T>
implements Field<T> {
    private final String title;
    private final Editor<T, Field<T>> editor;
    private T value;
    private T defaultValue;
    private EventListenerList listeners;

    public AbstractField(String title, Editor<T, ? extends Field<T>> editor) {
        this(title, editor, null);
    }

    public AbstractField(String title, Editor<T, ? extends Field<T>> editor, T defaultValue) {
        this.title = title;
        this.editor = editor;
        this.defaultValue = defaultValue;
        this.value = this.defaultValue;
        this.listeners = new EventListenerList();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Editor<T, Field<T>> getEditor() {
        return this.editor;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        if (value == null) {
            value = this.defaultValue;
        }
        if (!new EqualsBuilder().append(this.value, value).isEquals()) {
            T oldValue = this.value;
            this.value = value;
            this.fireChangeEvent(new ValueChangeEvent(this, ValueChangeEvent.Type.UPDATE, value, oldValue, null));
        }
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.listeners.add(ValueChangeListener.class, listener);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listeners.remove(ValueChangeListener.class, listener);
    }

    protected void fireChangeEvent(ValueChangeEvent event) {
        if (event == null) {
            event = new ValueChangeEvent(this, null, null, null, null);
        }
        for (Object listener : this.listeners.getListenerList()) {
            if (!(listener instanceof ValueChangeListener)) continue;
            ((ValueChangeListener)listener).valueChanged(event);
        }
    }
}

