/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.editor;

import de.datomino.util.assistant.editor.PagePanel;
import de.datomino.util.assistant.editor.WizardResultPanel;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.assistant.model.Wizard;
import de.datomino.util.callback.CallBack;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.ktde.swing.ButtonBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardDialog.class);
    private Window parent;
    private Wizard wizard;
    private Action forward;
    private Action backward;
    private Action finish;
    private Action cancel;
    private Worker.State userOption;
    private JDialog dialog;
    private Worker worker;
    private JTabbedPane tabbedPane;
    private int currentIndex;
    private JButton finishButton;
    private WizardResultPanel resultPage;
    private Image iconImage;

    public WizardDialog(Window parent, Wizard wizard, Worker worker, Image iconImage) {
        this.parent = parent;
        this.wizard = wizard;
        this.worker = worker;
        this.iconImage = iconImage;
    }

    public Worker.State show() {
        this.dialog = new JDialog(this.parent, this.wizard.getTitle(), Dialog.ModalityType.APPLICATION_MODAL);
        if (this.iconImage != null) {
            this.dialog.setIconImage(this.iconImage);
        }
        this.tabbedPane = new JTabbedPane();
        for (Page page : this.wizard.getPages()) {
            this.tabbedPane.addTab(page.getTitle(), new PagePanel(page));
        }
        this.dialog.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel buttonBoxPanel = new JPanel(new BorderLayout());
        buttonBoxPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonBox box = new ButtonBox();
        this.cancel = new AbstractAction("Abbrechen"){
            private static final long serialVersionUID = -5291442116703849506L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.cancel();
            }
        };
        this.forward = new AbstractAction("Weiter"){
            private static final long serialVersionUID = -6301546415241970476L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.forward();
            }
        };
        this.backward = new AbstractAction("Zur\u00fcck"){
            private static final long serialVersionUID = -4616661746601780519L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.backward();
            }
        };
        this.finish = new AbstractAction("Fertigstellen"){
            private static final long serialVersionUID = 961846718151757751L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.finish();
            }
        };
        box.add(new JButton(this.cancel));
        int countPages = this.wizard.countPages();
        if (countPages > 1) {
            ButtonBox multiPage = new ButtonBox();
            multiPage.add(new JButton(this.backward));
            multiPage.add(new JButton(this.forward));
            this.finish.setEnabled(false);
            buttonBoxPanel.add((Component)multiPage, "West");
        } else {
            this.forward.setEnabled(false);
            this.finish.setEnabled(true);
        }
        this.backward.setEnabled(false);
        this.finishButton = new JButton(this.finish);
        box.add(this.finishButton);
        buttonBoxPanel.add((Component)box, "East");
        this.dialog.add((Component)buttonBoxPanel, "South");
        this.currentIndex = 0;
        this.resultPage = new WizardResultPanel();
        this.tabbedPane.addTab("Ergebnis", this.resultPage);
        for (int i = 1; i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setEnabledAt(i, false);
        }
        this.userOption = Worker.State.CANCEL;
        this.dialog.pack();
        this.modifySize(this.dialog);
        SwingUtils.centerDialog(this.dialog, this.parent);
        this.dialog.setVisible(true);
        return this.userOption;
    }

    protected void modifySize(JDialog dialog) {
    }

    private void forward() {
        if (this.processLeaveActions()) {
            this.showTab(this.currentIndex + 1);
        }
    }

    private boolean processLeaveActions() {
        boolean wasError = false;
        List<CallBack<Boolean, Window>> leaveActions = this.wizard.getPageAt(this.currentIndex).getLeaveActions();
        for (CallBack<Boolean, Window> action : leaveActions) {
            try {
                wasError = action.execute((Window[])new Window[]{this.parent}) == false;
                if (!wasError) continue;
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                JOptionPane.showMessageDialog(this.dialog, "Fehler bei Eingabe", re.getMessage(), 0);
                wasError = true;
            }
            break;
        }
        return !wasError;
    }

    private void backward() {
        this.showTab(this.currentIndex - 1);
    }

    private void showTab(int index) {
        int countPages = this.wizard.countPages();
        if (index != this.currentIndex && index >= 0 && index <= countPages) {
            this.tabbedPane.setEnabledAt(index, true);
            this.tabbedPane.setSelectedIndex(index);
            this.tabbedPane.setEnabledAt(this.currentIndex, false);
            this.currentIndex = index;
            this.forward.setEnabled(index < countPages - 1);
            this.backward.setEnabled(index > 0);
            this.finish.setEnabled(index == countPages - 1);
        }
    }

    private void cancel() {
        this.dialog.dispose();
    }

    private void finish() {
        if (this.processLeaveActions()) {
            if (this.worker != null) {
                this.showTab(this.currentIndex + 1);
                this.finish.setEnabled(false);
                this.forward.setEnabled(false);
                this.backward.setEnabled(false);
                this.cancel.setEnabled(false);
                this.finishInternal();
            } else {
                this.resultPage.showResult("erfolgreich");
                this.userOption = Worker.State.OK;
            }
            this.finishButton.setAction(new AbstractAction("Beenden"){
                private static final long serialVersionUID = 6107277749636126853L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    WizardDialog.this.dialog.dispose();
                }
            });
        }
    }

    protected void finishInternal() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    WizardDialog.this.worker.process();
                    String resultString = WizardDialog.this.worker.getResultString();
                    WizardDialog.this.resultPage.showResult(resultString);
                    WizardDialog.this.userOption = WizardDialog.this.worker.getResultState();
                }
                catch (RuntimeException runtimeException) {
                    try {
                        LOGGER.error(runtimeException.getMessage(), runtimeException);
                    }
                    catch (Exception ex) {
                        System.err.println("Exception!");
                    }
                    WizardDialog.this.handleException(runtimeException);
                    WizardDialog.this.userOption = Worker.State.ERROR;
                }
            }
        };
        t.start();
    }

    protected Worker getWorker() {
        return this.worker;
    }

    protected WizardResultPanel getResultPage() {
        return this.resultPage;
    }

    protected void setUserOption(Worker.State userOption) {
        this.userOption = userOption;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    protected void handleException(RuntimeException runtimeException) {
        this.resultPage.showResult(runtimeException.getMessage());
    }
}

