/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.editor;

import de.datomino.util.assistant.editor.AbstractEditor;
import de.datomino.util.assistant.model.Field;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.ktde.util.datatypes.Tripel;

public class FileChooserEditor
extends AbstractEditor<File, Field<File>, JPanel, JTextField, JTextField> {
    private List<? extends FileFilter> fileFilters;

    public FileChooserEditor() {
        this(null);
    }

    public FileChooserEditor(List<? extends FileFilter> fileFilters) {
        this.fileFilters = fileFilters;
    }

    @Override
    public boolean needsTitle() {
        return true;
    }

    @Override
    protected Tripel<JPanel, JTextField, JTextField> createOuterComponent(Field<File> field) {
        JTextField textField = new JTextField(20);
        File element = field.getValue();
        if (element != null) {
            textField.setText(element.getAbsolutePath());
        }
        textField.addActionListener(new AbstractEditor.EditorActionListener(this));
        textField.addFocusListener(new AbstractEditor.EditorFocusListener(this));
        JButton button = new JButton(UIManager.getIcon("FileView.directoryIcon"));
        button.addActionListener(new FileEditorButtonListener());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)textField, "Center");
        panel.add((Component)button, "East");
        return new Tripel<JPanel, JTextField, JTextField>(panel, textField, textField);
    }

    @Override
    protected File getValueFromComponent(JTextField component) {
        String filename = component.getText().trim();
        if (filename.length() == 0) {
            return null;
        }
        return new File(filename);
    }

    @Override
    protected void setValueInComponent(File value, JTextField component) {
        if (value == null) {
            component.setText("");
        } else {
            component.setText(value.getAbsolutePath());
        }
    }

    public class FileEditorButtonListener
    implements ActionListener {
        private JFileChooser chooser;

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean oldnull;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
                if (FileChooserEditor.this.fileFilters != null && !FileChooserEditor.this.fileFilters.isEmpty()) {
                    for (FileFilter filter : FileChooserEditor.this.fileFilters) {
                        this.chooser.addChoosableFileFilter(filter);
                    }
                }
            }
            boolean bl = oldnull = FileChooserEditor.this.getValue() == null;
            if (!oldnull) {
                this.chooser.setCurrentDirectory(((File)FileChooserEditor.this.getValue()).getParentFile());
            }
            if (this.chooser.showOpenDialog((Component)FileChooserEditor.this.getComponent()) == 0) {
                File f = this.chooser.getSelectedFile();
                FileChooserEditor.this.setValue(f);
            }
        }
    }
}

