/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.tsp;

import de.datomino.util.algorithm.tsp.AbstractTsp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.ChristophidesMinTspFinder;
import org.ktde.util.datatypes.Tupel;

public class ChristofidesTsp<T>
extends AbstractTsp<T> {
    public ChristofidesTsp(Map<T, Collection<Tupel<T, Double>>> adjacencyLists, Map<T, Collection<Tupel<Double, Double>>> wayLimits, Map<T, Double> stopWeight, T startPoint, T endPoint) {
        super(adjacencyLists, wayLimits, stopWeight, startPoint, endPoint);
    }

    @Override
    protected List<Integer> perform(Double[][] matrix, Map<Integer, Collection<Tupel<Double, Double>>> limits, Map<Integer, Double> pointWeights, Integer startPointIndex, Integer endPointIndex) {
        boolean hasNext;
        Edge<Object> edge;
        Node node;
        int i;
        Graph graph = new Graph();
        ArrayList<Node> nodes = new ArrayList<Node>(matrix.length);
        for (i = 0; i < matrix.length; ++i) {
            node = new Node(i);
            graph.addNode(node);
            nodes.add(node);
        }
        for (i = 0; i < matrix.length; ++i) {
            node = (Node)nodes.get(i);
            for (int j = 0; j < matrix.length; ++j) {
                Double cost = matrix[i][j];
                if (cost == null) continue;
                edge = new Edge(node, (Node)nodes.get(j), new double[]{cost});
                graph.addEdge(edge);
            }
        }
        ChristophidesMinTspFinder christophidesMinTspFinder = new ChristophidesMinTspFinder(graph, 0);
        Vector<Edge<?>> edges = christophidesMinTspFinder.findTour();
        ArrayList<Integer> solution = new ArrayList<Integer>(matrix.length);
        Iterator<Edge<?>> iterator = edges.iterator();
        edge = iterator.next();
        do {
            solution.add((Integer)edge.getStart().getAssociatedObject());
            hasNext = iterator.hasNext();
            if (!hasNext) continue;
            edge = iterator.next();
        } while (hasNext);
        solution.add((Integer)edge.getTarget().getAssociatedObject());
        return solution;
    }

    @Override
    protected int preCalcSteps(Double[][] matrix, Map<Integer, Collection<Tupel<Double, Double>>> limits2, Map<Integer, Double> pointWeights) {
        return 0;
    }
}

