/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.tsp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.algorithm.InputDataValidationException;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractTsp<T>
extends Algorithm {
    private Map<T, Integer> matrixMapping;
    private Map<Integer, T> reverseMatrixMapping;
    private Double[][] matrix;
    private List<T> solution;
    private List<T> currentSolution;
    private Double currentBestValue;
    private Map<Integer, Collection<Tupel<Double, Double>>> limits;
    private Map<Integer, Double> pointWeights;
    private Integer startPointIndex;
    private Integer endPointIndex;

    public AbstractTsp(Map<T, Collection<Tupel<T, Double>>> adjacencyLists, Map<T, Collection<Tupel<Double, Double>>> wayLimits, Map<T, Double> stopWeight, T startPoint, T endPoint) throws IllegalArgumentException {
        this.createMatrixMapping(adjacencyLists, startPoint, endPoint);
        this.createMatrix(adjacencyLists);
        this.createLimitMap(wayLimits);
        this.createStopWeights(stopWeight);
    }

    private void createStopWeights(Map<T, Double> stopWeight) {
        if (stopWeight == null) {
            this.pointWeights = Collections.emptyMap();
        } else {
            this.pointWeights = new HashMap<Integer, Double>();
            for (Map.Entry<T, Double> entry : stopWeight.entrySet()) {
                Integer i = this.matrixMapping.get(entry.getKey());
                this.pointWeights.put(i, entry.getValue());
            }
        }
    }

    private void createLimitMap(Map<T, Collection<Tupel<Double, Double>>> wayLimits) {
        if (wayLimits == null) {
            this.limits = Collections.emptyMap();
        } else {
            this.limits = new HashMap<Integer, Collection<Tupel<Double, Double>>>();
            for (Map.Entry<T, Collection<Tupel<Double, Double>>> entry : wayLimits.entrySet()) {
                Integer i = this.matrixMapping.get(entry.getKey());
                this.limits.put(i, entry.getValue());
            }
        }
    }

    private void createMatrix(Map<T, Collection<Tupel<T, Double>>> adjacencyLists2) {
        this.matrix = new Double[this.matrixMapping.size()][this.matrixMapping.size()];
        for (Map.Entry<T, Collection<Tupel<T, Double>>> entry : adjacencyLists2.entrySet()) {
            T t = entry.getKey();
            int index1 = this.matrixMapping.get(t);
            for (Tupel<T, Double> weight : entry.getValue()) {
                int index2 = this.matrixMapping.get(weight.getElement1());
                this.matrix[index1][index2] = weight.getElement2();
            }
        }
    }

    private void createMatrixMapping(Map<T, Collection<Tupel<T, Double>>> adjacencyLists2, T startPoint, T endPoint) {
        this.matrixMapping = new HashMap<T, Integer>();
        this.reverseMatrixMapping = new HashMap<Integer, T>();
        int counter = 0;
        for (T t : adjacencyLists2.keySet()) {
            this.matrixMapping.put(t, counter);
            this.reverseMatrixMapping.put(counter, t);
            if (startPoint != null && t.equals(startPoint)) {
                this.startPointIndex = counter;
            }
            if (endPoint != null && t.equals(endPoint)) {
                this.endPointIndex = counter;
            }
            ++counter;
        }
    }

    @Override
    protected void perform() throws AlgorithmException {
        List<Integer> order = this.perform(this.matrix, this.limits, this.pointWeights, this.startPointIndex, this.endPointIndex);
        if (order == null) {
            this.solution = null;
        } else {
            this.solution = new ArrayList<T>(order.size() + (this.startPointIndex == null ? 0 : 1) + (this.endPointIndex == null ? 0 : 1));
            if (this.startPointIndex != null) {
                this.solution.add(this.reverseMatrixMapping.get(this.startPointIndex));
            }
            for (Integer o : order) {
                this.solution.add(this.reverseMatrixMapping.get(o));
            }
            if (this.endPointIndex != null) {
                this.solution.add(this.reverseMatrixMapping.get(this.endPointIndex));
            }
        }
    }

    protected abstract List<Integer> perform(Double[][] var1, Map<Integer, Collection<Tupel<Double, Double>>> var2, Map<Integer, Double> var3, Integer var4, Integer var5);

    @Override
    public int preCalcSteps() {
        return this.preCalcSteps(this.matrix, this.limits, this.pointWeights);
    }

    protected abstract int preCalcSteps(Double[][] var1, Map<Integer, Collection<Tupel<Double, Double>>> var2, Map<Integer, Double> var3);

    @Override
    protected void validateInput() throws InputDataValidationException {
    }

    protected void setCurrentSolution(List<Integer> solution) {
        ArrayList<T> currentTemp = new ArrayList<T>(solution.size());
        for (Integer i : solution) {
            currentTemp.add(this.reverseMatrixMapping.get(i));
        }
        this.currentSolution = currentTemp;
    }

    protected void setCurrentBestValue(Double currentBestValue) {
        this.currentBestValue = currentBestValue;
    }

    public List<T> getSolution() {
        return this.solution;
    }

    public List<T> getCurrentSolution() {
        return Collections.unmodifiableList(this.currentSolution);
    }

    public Double getCurrentBestValue() {
        return this.currentBestValue;
    }
}

