/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.smooth;

import de.datomino.util.algorithm.selfintersection.PolygonSelfIntersectionKiller;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableGeometryCollection;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.GeoUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.algorithm.InputDataValidationException;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolygonSmoother
extends Algorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolygonSmoother.class);
    private Collection<ImmutablePolygonKind> input;
    private double distance;
    private ImmutablePolygonKind result;
    private CoordinateFactory resultFactory;

    public PolygonSmoother(Collection<ImmutablePolygonKind> input, double distance, CoordinateFactory resultFactory) {
        this.input = input;
        this.distance = distance;
        this.resultFactory = resultFactory;
    }

    @Override
    protected void perform() throws AlgorithmException {
        ArrayList<ImmutablePolygonKind> input2 = new ArrayList<ImmutablePolygonKind>(this.input.size());
        for (ImmutablePolygonKind i : this.input) {
            if (i == null) continue;
            input2.add((ImmutablePolygonKind)i.getTransformed(GeoDecimal100Factory.INSTANCE));
        }
        this.input = input2;
        LOGGER.info("Stretching polygons");
        List<ImmutablePolygonKind> strechted = this.stretchPolygons();
        if (!strechted.isEmpty()) {
            LOGGER.info("Calculating intersections");
            Collection<ImmutablePolygonKind> intersections = this.calculateIntersections(strechted);
            LOGGER.info(intersections.size() + " intersections found");
            if (!intersections.isEmpty()) {
                LOGGER.info("Cutting horns");
                Tupel<ImmutablePolygonKind, ImmutablePolygonKind> newPolygons = this.cutHorns(this.input, intersections);
                LOGGER.info("Dropping cut holes");
                ImmutablePolygonKind newPolygon = this.dropCutHoles(newPolygons.getElement2(), newPolygons.getElement1());
                LOGGER.info("Restoring holes");
                newPolygon = this.restoreHoles(newPolygon);
                this.result = (ImmutablePolygonKind)newPolygon.getTransformed(this.resultFactory);
            }
        }
        if (this.result == null) {
            this.result = this.union(this.input, false);
        }
        LOGGER.info("Done");
    }

    private ImmutablePolygonKind dropCutHoles(ImmutablePolygonKind bigOrig, ImmutablePolygonKind smooth) {
        LinkedList<ImmutableLineString> holes = new LinkedList<ImmutableLineString>();
        if (smooth instanceof ImmutablePolygon) {
            ImmutablePolygon p = (ImmutablePolygon)smooth;
            holes.addAll(p.getHoles());
        } else if (smooth instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon pm = (ImmutableMultiPolygon)smooth;
            for (ImmutablePolygon part : pm.getParts()) {
                holes.addAll(part.getHoles());
            }
        }
        LinkedList<ImmutablePolygonKind> toAdd = new LinkedList<ImmutablePolygonKind>();
        toAdd.add(smooth);
        for (ImmutableLineString hole : holes) {
            try {
                ImmutablePolygonKind o;
                ImmutablePolygon p = ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(hole, new ImmutableLineString[0]);
                int count = 0;
                Iterator<ImmutablePolygonKind> iterator = this.input.iterator();
                while (!(!iterator.hasNext() || (o = iterator.next()).touches(p) && o.intersects(p) && o.contains(p) && ++count > 1)) {
                }
                if (count > true) continue;
                toAdd.add(p);
            }
            catch (IllegalPointCountException e) {
                LOGGER.warn("Could not create hole polygon");
            }
        }
        return this.union(toAdd, true);
    }

    private Tupel<ImmutablePolygonKind, ImmutablePolygonKind> cutHorns(Collection<ImmutablePolygonKind> origs, Collection<ImmutablePolygonKind> intersections) {
        LOGGER.info("Creating big original union");
        ImmutablePolygonKind bigOrig = this.union(origs, false);
        LinkedList<ImmutablePolygonKind> cuts = new LinkedList<ImmutablePolygonKind>();
        int count = 0;
        for (ImmutablePolygonKind intersection : intersections) {
            LOGGER.info("Calculating overlap for intersection " + count + "/" + intersections.size());
            if (intersection instanceof ImmutablePolygon) {
                ImmutablePolygonKind cut = this.cutHornsSub2(bigOrig, intersection);
                if (cut != null) {
                    cuts.add(cut);
                }
            } else if (intersection instanceof ImmutableMultiPolygon) {
                ImmutableMultiPolygon multi = (ImmutableMultiPolygon)intersection;
                for (ImmutablePolygon part : multi.getParts()) {
                    ImmutablePolygonKind cut = this.cutHornsSub2(bigOrig, part);
                    if (cut == null) continue;
                    cuts.add(cut);
                }
            }
            ++count;
        }
        LOGGER.info(cuts.size() + " cuts found");
        ArrayList<ImmutablePolygonKind> all = new ArrayList<ImmutablePolygonKind>(cuts.size() + 1);
        all.add(bigOrig);
        all.addAll(cuts);
        return new Tupel<ImmutablePolygonKind, ImmutablePolygonKind>(this.union(all, true), bigOrig);
    }

    private Collection<ImmutablePolygonKind> calculateIntersections(List<ImmutablePolygonKind> strechted) {
        LinkedList<ImmutablePolygonKind> intersections = new LinkedList<ImmutablePolygonKind>();
        ListIterator<ImmutablePolygonKind> iter1 = strechted.listIterator();
        int outerCount = 0;
        while (iter1.hasNext()) {
            ImmutablePolygonKind stretched1 = iter1.next();
            ListIterator<ImmutablePolygonKind> iter2 = strechted.listIterator(iter1.nextIndex());
            int innerCount = outerCount + 1;
            while (iter2.hasNext()) {
                LOGGER.info("Intersecting " + outerCount + " " + innerCount);
                ImmutablePolygonKind strechted2 = iter2.next();
                ImmutableGeoObject intersection = stretched1.intersection(strechted2);
                ImmutablePolygonKind polygon = null;
                if (intersection instanceof ImmutablePolygonKind) {
                    polygon = (ImmutablePolygonKind)intersection;
                } else if (intersection instanceof ImmutableGeometryCollection) {
                    polygon = ((ImmutableGeometryCollection)intersection).unionPolygonsToOneMultiPolygon();
                }
                if (polygon != null) {
                    intersections.add(polygon);
                }
                ++innerCount;
            }
            ++outerCount;
        }
        return intersections;
    }

    private ImmutablePolygonKind restoreHoles(ImmutablePolygonKind newPolygon) {
        LinkedList<ImmutableLineString> holes = new LinkedList<ImmutableLineString>();
        for (ImmutablePolygonKind polygon : this.input) {
            if (polygon instanceof ImmutableMultiPolygon) {
                ImmutableMultiPolygon multi = (ImmutableMultiPolygon)polygon;
                for (ImmutablePolygon part : multi.getParts()) {
                    holes.addAll(part.getHoles());
                }
                continue;
            }
            if (!(polygon instanceof ImmutablePolygon)) continue;
            ImmutablePolygon sPolygon = (ImmutablePolygon)polygon;
            holes.addAll(sPolygon.getHoles());
        }
        ImmutablePolygonKind new2 = newPolygon;
        for (ImmutableLineString hole : holes) {
            try {
                ImmutablePolygon holePolygon = ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(hole, new ImmutableLineString[0]);
                ImmutableGeoObject diff = new2.difference(holePolygon);
                if (diff instanceof ImmutablePolygonKind) {
                    new2 = (ImmutablePolygonKind)diff;
                    continue;
                }
                if (diff instanceof ImmutableGeometryCollection) {
                    new2 = ((ImmutableGeometryCollection)diff).unionPolygonsToOneMultiPolygon();
                    continue;
                }
                LOGGER.warn("Unexpected union result type: " + diff);
            }
            catch (IllegalPointCountException e) {
                LOGGER.warn("Bad hole");
            }
        }
        for (ImmutablePolygonKind polygon : this.input) {
            if (polygon == null) continue;
            try {
                ImmutableGeoObject union = new2.union(polygon);
                if (union instanceof ImmutablePolygonKind) {
                    new2 = (ImmutablePolygonKind)union;
                    continue;
                }
                if (union instanceof ImmutableGeometryCollection) {
                    new2 = ((ImmutableGeometryCollection)union).unionPolygonsToOneMultiPolygon();
                    continue;
                }
                LOGGER.warn("Unexpected union result type: " + union);
            }
            catch (Exception e) {
                PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(new2);
                polygonSelfIntersectionKiller.start(false);
                new2 = polygonSelfIntersectionKiller.getResult();
                polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(polygon);
                polygonSelfIntersectionKiller.start(false);
                polygon = polygonSelfIntersectionKiller.getResult();
                ImmutableGeoObject union = new2.union(polygon);
                if (union instanceof ImmutablePolygonKind) {
                    new2 = (ImmutablePolygonKind)union;
                    continue;
                }
                if (union instanceof ImmutableGeometryCollection) {
                    new2 = ((ImmutableGeometryCollection)union).unionPolygonsToOneMultiPolygon();
                    continue;
                }
                LOGGER.warn("Unexpected union result type: " + union);
            }
        }
        return new2;
    }

    private ImmutablePolygonKind cutHornsSub2(ImmutablePolygonKind bigUnion, ImmutablePolygonKind polygon) {
        ImmutableGeoObject intersection = bigUnion.intersection(polygon);
        ImmutablePolygonKind intersectionPoly = null;
        if (intersection instanceof ImmutablePolygonKind) {
            intersectionPoly = (ImmutablePolygonKind)intersection;
        } else if (intersection instanceof ImmutableGeometryCollection) {
            intersectionPoly = ((ImmutableGeometryCollection)intersection).unionPolygonsToOneMultiPolygon();
        }
        if (intersectionPoly == null) {
            return null;
        }
        List<ImmutablePoint> list = null;
        if (intersectionPoly instanceof ImmutablePolygon) {
            list = ((ImmutablePolygon)intersectionPoly).getShell().getCoordinates();
        } else if (intersectionPoly instanceof ImmutableMultiPolygon) {
            list = new LinkedList<ImmutablePoint>();
            ImmutableMultiPolygon multi = (ImmutableMultiPolygon)intersectionPoly;
            for (ImmutablePolygon poly : multi.getParts()) {
                list.addAll(poly.getShell().getCoordinates());
            }
        }
        try {
            ImmutablePolygon convexHull = GeoUtils.getConvexHull(list);
            return convexHull;
        }
        catch (IllegalPointCountException e) {
            return null;
        }
    }

    private <T extends ImmutablePolygonKind> ImmutablePolygonKind union(Collection<T> polygons, boolean ignoreErrors) {
        if (polygons.isEmpty()) {
            return null;
        }
        Iterator<T> iter = polygons.iterator();
        ImmutablePolygonKind bigPolygon = (ImmutablePolygonKind)iter.next();
        while (bigPolygon == null && iter.hasNext()) {
            bigPolygon = (ImmutablePolygonKind)iter.next();
        }
        while (iter.hasNext()) {
            ImmutablePolygonKind next = (ImmutablePolygonKind)iter.next();
            if (next == null) continue;
            try {
                bigPolygon = this.union(bigPolygon, next);
            }
            catch (RuntimeException ex) {
                if (!ignoreErrors) {
                    throw ex;
                }
                LOGGER.warn("Could not union. Ignoring!");
            }
        }
        return bigPolygon;
    }

    private ImmutablePolygonKind union(ImmutablePolygonKind polygon1, ImmutablePolygonKind polygon2) {
        try {
            ImmutableGeoObject big2 = polygon1.union(polygon2);
            if (big2 instanceof ImmutablePolygonKind) {
                polygon1 = (ImmutablePolygonKind)big2;
            } else if (big2 instanceof ImmutableGeometryCollection) {
                polygon1 = ((ImmutableGeometryCollection)big2).unionPolygonsToOneMultiPolygon();
            } else {
                LOGGER.warn("Unexpected union result type: " + big2);
            }
        }
        catch (Exception ex) {
            PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(polygon1);
            polygonSelfIntersectionKiller.start(false);
            polygon1 = polygonSelfIntersectionKiller.getResult();
            polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(polygon2);
            polygonSelfIntersectionKiller.start(false);
            polygon2 = polygonSelfIntersectionKiller.getResult();
            ImmutableGeoObject big2 = polygon1.union(polygon2);
            if (big2 instanceof ImmutablePolygonKind) {
                polygon1 = (ImmutablePolygonKind)big2;
            }
            if (big2 instanceof ImmutableGeometryCollection) {
                polygon1 = ((ImmutableGeometryCollection)big2).unionPolygonsToOneMultiPolygon();
            }
            LOGGER.warn("Unexpected union result type: " + big2);
        }
        return polygon1;
    }

    private List<ImmutablePolygonKind> stretchPolygons() {
        ArrayList<ImmutablePolygonKind> stretchList = new ArrayList<ImmutablePolygonKind>(this.input.size());
        for (ImmutablePolygonKind polygon : this.input) {
            if (polygon == null) continue;
            ImmutablePolygonKind stretched = this.stretchBlocks(polygon, this.distance);
            stretchList.add(stretched);
        }
        return stretchList;
    }

    private ImmutablePolygonKind stretchBlocks(ImmutablePolygonKind polygon, double dist) {
        if (polygon instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multiPolygon = (ImmutableMultiPolygon)polygon;
            ImmutablePolygonKind result = null;
            for (ImmutablePolygon sPolygon : multiPolygon.getParts()) {
                ImmutablePolygonKind stretch = this.stretchBlockPolygon2(sPolygon, dist);
                if (stretch == null) continue;
                if (result == null) {
                    result = stretch;
                    continue;
                }
                try {
                    result = this.union(result, stretch);
                }
                catch (Exception ex) {
                    result = this.union(result, polygon);
                }
            }
            return result;
        }
        if (polygon instanceof ImmutablePolygon) {
            ImmutablePolygon sPolygon = (ImmutablePolygon)polygon;
            ImmutablePolygonKind stretch = this.stretchBlockPolygon2(sPolygon, dist);
            return stretch;
        }
        return polygon;
    }

    private ImmutablePolygonKind stretchBlockPolygon2(ImmutablePolygon polygon, double dist) {
        CoordinateFactory coordinateFactory = polygon.getCoordinateFactory();
        List<ImmutablePoint> points = GeoUtils.filterMultiplePoints(polygon.getShell().getCoordinates());
        int size = points.size();
        if (points.get(0).equals(points.get(size - 1))) {
            points.remove(size - 1);
        }
        points.add(points.get(0));
        points.add(points.get(1));
        ListIterator<ImmutablePoint> iter = points.listIterator();
        ImmutablePoint p1 = iter.next();
        ImmutablePoint p2 = iter.next();
        LinkedList<ImmutablePolygonKind> list = new LinkedList<ImmutablePolygonKind>();
        while (iter.hasNext()) {
            ImmutablePoint p3 = iter.next();
            ImmutablePoint lc1 = this.getNormalPoint(p1, p2, dist, false, coordinateFactory);
            ImmutablePoint lc2 = this.getNormalPoint(p1, p2, dist, true, coordinateFactory);
            ImmutablePoint ss1 = this.getNormalPoint(p2, p1, dist, false, coordinateFactory);
            ImmutablePoint ss2 = this.getNormalPoint(p2, p1, dist, true, coordinateFactory);
            ImmutablePoint rc1 = this.getNormalPoint(p3, p2, dist, false, coordinateFactory);
            ImmutablePoint rc2 = this.getNormalPoint(p3, p2, dist, true, coordinateFactory);
            ImmutablePoint rs1 = this.getNormalPoint(p2, p3, dist, false, coordinateFactory);
            ImmutablePoint rs2 = this.getNormalPoint(p2, p3, dist, true, coordinateFactory);
            try {
                ImmutablePolygon block1 = GeoUtils.getConvexHull(Arrays.asList(lc1, lc2, ss1, ss2));
                ImmutablePolygon block2 = GeoUtils.getConvexHull(Arrays.asList(rc1, rc2, rs1, rs2));
                ImmutablePolygonKind p = this.union(block1, block2);
                if (!lc1.equals(rc1) && !lc2.equals(rc2)) {
                    ImmutablePolygon cBlock;
                    Collection<ImmutablePoint> middleOuterPoint1 = this.getMiddleOuterPoints(lc1, rc1, p2, dist, false, coordinateFactory);
                    Collection<ImmutablePoint> middleOuterPoint2 = this.getMiddleOuterPoints(lc1, rc1, p2, dist, true, coordinateFactory);
                    Collection<ImmutablePoint> middleOuterPoint3 = this.getMiddleOuterPoints(lc2, rc2, p2, dist, false, coordinateFactory);
                    Collection<ImmutablePoint> middleOuterPoint4 = this.getMiddleOuterPoints(lc2, rc2, p2, dist, true, coordinateFactory);
                    try {
                        LinkedList<ImmutablePoint> pointList = new LinkedList<ImmutablePoint>();
                        pointList.add(lc1);
                        pointList.add(lc2);
                        pointList.add(rc1);
                        pointList.add(rc2);
                        pointList.addAll(middleOuterPoint1);
                        pointList.addAll(middleOuterPoint2);
                        pointList.addAll(middleOuterPoint3);
                        pointList.addAll(middleOuterPoint4);
                        cBlock = GeoUtils.getConvexHull(pointList);
                        p = this.union(p, cBlock);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Could not strech corner. Trying rectangle only");
                        try {
                            cBlock = GeoUtils.getConvexHull(Arrays.asList(lc1, lc2, rc1, rc2));
                            p = this.union(p, cBlock);
                        }
                        catch (Exception ex2) {
                            LOGGER.warn("Could not add center block.");
                        }
                    }
                }
                list.add(p);
            }
            catch (IllegalPointCountException e) {
                throw new RuntimeException(e);
            }
            catch (NullPointerException e) {
                throw e;
            }
            p1 = p2;
            p2 = p3;
        }
        ImmutablePolygonKind resultPolygon = this.union(list, true);
        try {
            if (resultPolygon instanceof ImmutablePolygon) {
                resultPolygon = ImmutableGeoObjectFactory.createImmutablePolygon(((ImmutablePolygon)resultPolygon).getShell().getCoordinates());
            } else if (resultPolygon instanceof ImmutableMultiPolygon) {
                ImmutableMultiPolygon multi = (ImmutableMultiPolygon)resultPolygon;
                List parts = multi.getParts();
                ArrayList<ImmutablePolygon> nParts = new ArrayList<ImmutablePolygon>(parts.size());
                for (ImmutablePolygon part : parts) {
                    nParts.add(ImmutableGeoObjectFactory.createImmutablePolygon(part.getShell().getCoordinates()));
                }
                resultPolygon = this.union(nParts, true);
            }
        }
        catch (IllegalPointCountException e) {
            return null;
        }
        return resultPolygon;
    }

    private Collection<ImmutablePoint> getMiddleOuterPoints(ImmutablePoint o1, ImmutablePoint o2, ImmutablePoint centerPoint, double dist, boolean minus, CoordinateFactory coordinateFactory) {
        double rDist = GeoUtils.getDistanceInMeter(o1.getCoordinate(), o2.getCoordinate());
        LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>();
        if (rDist > 0.0) {
            double tx = o2.getX() - o1.getX();
            double ty = o2.getY() - o1.getY();
            long steps = Math.round(Math.floor(rDist / 1.0)) - 1L;
            for (long l = 0L; l < steps; ++l) {
                double factor = (double)(l + 1L) * 1.0;
                double mx = o1.getX() + tx * factor;
                double my = o1.getY() + ty * factor;
                double vx1 = mx - centerPoint.getX();
                double vy1 = my - centerPoint.getY();
                if (vx1 == 0.0 && vy1 == 0.0) continue;
                if (minus) {
                    vx1 *= -1.0;
                    vy1 *= -1.0;
                }
                Coordinate ref = coordinateFactory.createCoordinate(centerPoint.getX() + vx1, centerPoint.getY() + vy1);
                double length1 = GeoUtils.getDistanceInMeter(centerPoint.getCoordinate(), ref);
                while (length1 == 0.0) {
                    ref = coordinateFactory.createCoordinate(centerPoint.getX() + (vx1 *= 10.0), centerPoint.getY() + (vy1 *= 10.0));
                    length1 = GeoUtils.getDistanceInMeter(centerPoint.getCoordinate(), ref);
                }
                Coordinate c1 = coordinateFactory.createCoordinate(centerPoint.getX() + (vx1 *= dist / length1), centerPoint.getY() + (vy1 *= dist / length1));
                ImmutablePoint point = ImmutableGeoObjectFactory.createImmutablePoint(c1);
                double nDist = GeoUtils.getDistanceInMeter(centerPoint.getCoordinate(), point.getCoordinate());
                if (nDist < dist - 5.0 || nDist > dist + 5.0) {
                    System.out.println(nDist);
                }
                points.add(point);
            }
        }
        return points;
    }

    private ImmutablePoint getNormalPoint(ImmutablePoint toPoint, ImmutablePoint fromPoint, double dist, boolean minus, CoordinateFactory coordinateFactory) {
        double vx1 = toPoint.getX() - fromPoint.getX();
        double vy1 = toPoint.getY() - fromPoint.getY();
        if (vx1 == 0.0 && vy1 == 0.0) {
            return null;
        }
        double nx1 = vy1 * (double)(minus ? 1 : -1);
        double ny1 = vx1 * (double)(minus ? -1 : 1);
        Coordinate ref = coordinateFactory.createCoordinate(fromPoint.getX() + nx1, fromPoint.getY() + ny1);
        double length1 = GeoUtils.getDistanceInMeter(fromPoint.getCoordinate(), ref);
        while (length1 == 0.0) {
            ref = coordinateFactory.createCoordinate(fromPoint.getX() + (nx1 *= 10.0), fromPoint.getY() + (ny1 *= 10.0));
            length1 = GeoUtils.getDistanceInMeter(fromPoint.getCoordinate(), ref);
        }
        Coordinate c1 = coordinateFactory.createCoordinate(fromPoint.getX() + (nx1 *= dist / length1), fromPoint.getY() + (ny1 *= dist / length1));
        ImmutablePoint point = ImmutableGeoObjectFactory.createImmutablePoint(c1);
        return point;
    }

    @Override
    public int preCalcSteps() {
        return 1;
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
    }

    public ImmutablePolygonKind getResult() {
        return this.result;
    }
}

