/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.selfintersection;

import de.datomino.util.algorithm.selfintersection.SelfIntersectionKiller;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.util.Collections;
import java.util.List;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.algorithm.InputDataValidationException;

public class PolygonSelfIntersectionKiller
extends Algorithm {
    private ImmutablePolygonKind immutablePolygon;
    private ImmutablePolygonKind result;

    public PolygonSelfIntersectionKiller(ImmutablePolygonKind immutablePolygonKind) {
        this.immutablePolygon = immutablePolygonKind;
    }

    @Override
    protected void perform() throws AlgorithmException {
        List<ImmutablePolygon> polygons;
        if (this.immutablePolygon instanceof ImmutablePolygon) {
            polygons = Collections.singletonList((ImmutablePolygon)this.immutablePolygon);
        } else {
            ImmutableMultiPolygon immutableMultiPolygon = (ImmutableMultiPolygon)this.immutablePolygon;
            polygons = immutableMultiPolygon.getParts();
        }
        for (ImmutablePolygon immutablePolygon : polygons) {
            SelfIntersectionKiller selfIntersectionKiller = new SelfIntersectionKiller(Collections.singletonList(immutablePolygon.getShell().getCoordinates()), true);
            selfIntersectionKiller.start(false);
            ImmutablePolygonKind subResult = selfIntersectionKiller.getResult();
            if (this.result == null) {
                this.result = subResult;
            } else if (subResult != null) {
                this.result = (ImmutablePolygonKind)this.result.union(subResult);
            }
            for (ImmutableLineString immutableLineString : immutablePolygon.getHoles()) {
                SelfIntersectionKiller subSelfIntersectionKiller = new SelfIntersectionKiller(Collections.singletonList(immutableLineString.getCoordinates()), true);
                subSelfIntersectionKiller.start(false);
                ImmutablePolygonKind hole = subSelfIntersectionKiller.getResult();
                try {
                    this.result = (ImmutablePolygonKind)this.result.difference(hole);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int preCalcSteps() {
        return 0;
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
    }

    public ImmutablePolygonKind getResult() {
        return this.result;
    }
}

