/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.polygonshrink;

import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.GeoUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.ktde.math.helper.ComputeTrigonometrics;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.algorithm.InputDataValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolygonShrinker
extends Algorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolygonShrinker.class);
    private List<List<ImmutablePoint>> points;
    private double distance;
    private List<List<ImmutablePoint>> result;

    public PolygonShrinker(List<List<ImmutablePoint>> points, double distance) {
        this.points = points;
        this.distance = distance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void perform() throws AlgorithmException {
        LinkedList<List<ImmutablePoint>> shrinkedPoly = new LinkedList<List<ImmutablePoint>>();
        ListIterator<List<ImmutablePoint>> outerIter = this.points.listIterator();
        while (outerIter.hasNext()) {
            void var6_7;
            LinkedList<ImmutablePoint> shrinkedPart = new LinkedList<ImmutablePoint>();
            List<ImmutablePoint> currentPart = outerIter.next();
            int outerPrevious = outerIter.previousIndex() - 1;
            int outerNext = outerIter.nextIndex();
            List<ImmutablePoint> previousPart = outerPrevious < 0 ? this.points.get(this.points.size() - 1) : this.points.get(outerPrevious);
            if (outerNext >= this.points.size()) {
                List<ImmutablePoint> list = this.points.get(0);
            } else {
                List<ImmutablePoint> list = this.points.get(outerNext);
            }
            ListIterator<ImmutablePoint> innerIter = currentPart.listIterator();
            ImmutablePoint previous = previousPart.get(previousPart.size() - 2);
            ImmutablePoint current = innerIter.next();
            ImmutablePoint next = innerIter.next();
            ImmutablePoint shrinked = this.moveOnAngel(previous, current, next, this.distance);
            shrinkedPart.add(shrinked);
            while (innerIter.hasNext()) {
                previous = current;
                current = next;
                next = innerIter.next();
                shrinked = this.moveOnAngel(previous, current, next, this.distance);
                shrinkedPart.add(shrinked);
            }
            previous = current;
            current = next;
            next = (ImmutablePoint)var6_7.get(1);
            shrinked = this.moveOnAngel(previous, current, next, this.distance);
            shrinkedPart.add(shrinked);
            shrinkedPoly.add(shrinkedPart);
        }
        LinkedList<ImmutablePoint> filteredPoints = new LinkedList<ImmutablePoint>();
        ImmutablePoint pred = null;
        for (List list : shrinkedPoly) {
            for (ImmutablePoint point : list) {
                if (pred == null || !pred.equals(point)) {
                    filteredPoints.add(point);
                }
                pred = point;
            }
        }
        try {
            ImmutablePolygon polygon = ImmutableGeoObjectFactory.createImmutablePolygon(filteredPoints);
            if (!GeoUtils.isSelfIntersecting(polygon, false)) {
                LinkedList<ImmutablePoint> linkedList = new LinkedList<ImmutablePoint>();
                pred = null;
                for (List<ImmutablePoint> list : this.points) {
                    for (ImmutablePoint point : list) {
                        if (pred == null || !pred.equals(point)) {
                            linkedList.add(point);
                        }
                        pred = point;
                    }
                }
                ImmutablePolygon origPolygon = ImmutableGeoObjectFactory.createImmutablePolygon(linkedList);
                if (origPolygon.contains(polygon)) {
                    this.result = shrinkedPoly;
                }
            } else {
                LOGGER.warn("could not create polygon due to self intersections");
            }
        }
        catch (IllegalPointCountException e) {
            LOGGER.warn("could not create polygon due to less points");
        }
    }

    public List<List<ImmutablePoint>> getResult() {
        return this.result;
    }

    private ImmutablePoint moveOnAngel(ImmutablePoint previous, ImmutablePoint current, ImmutablePoint next, double distance2) {
        double x1 = next.getX() - current.getX();
        double y1 = next.getY() - current.getY();
        double angle1 = ComputeTrigonometrics.normalizeAngle(Math.atan2(y1, x1));
        double x2 = previous.getX() - current.getX();
        double y2 = previous.getY() - current.getY();
        double angle2 = ComputeTrigonometrics.normalizeAngle(Math.atan2(y2, x2));
        double angle = angle2 + (angle1 - angle2) / 2.0;
        if (angle1 < angle2) {
            angle += Math.PI;
        }
        double ry = Math.sin(angle) * distance2;
        double rx = Math.cos(angle) * distance2;
        return ImmutableGeoObjectFactory.createImmutablePoint(current.getCoordinateFactory().createCoordinate(current.getX() + rx, current.getY() + ry));
    }

    @Override
    public int preCalcSteps() {
        return 0;
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
        if (this.points.isEmpty()) {
            throw new InputDataValidationException();
        }
        Iterator<List<ImmutablePoint>> iter = this.points.iterator();
        List<ImmutablePoint> pred = iter.next();
        ImmutablePoint first = pred.get(0);
        List<ImmutablePoint> succ = pred;
        while (iter.hasNext()) {
            ImmutablePoint succFirst;
            succ = iter.next();
            ImmutablePoint predLast = pred.get(pred.size() - 1);
            if (!predLast.equals(succFirst = succ.get(0))) {
                throw new InputDataValidationException();
            }
            pred = succ;
        }
        ImmutablePoint last = pred.get(pred.size() - 1);
        if (!first.equals(last)) {
            throw new InputDataValidationException();
        }
    }
}

