/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.pairfinder.allinpolygon;

import com.vividsolutions.jts.geom.TopologyException;
import de.datomino.util.algorithm.componentfinder.PlainComponentFinder;
import de.datomino.util.algorithm.pairfinder.boundline.BoundLinePairFinder;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.AbstractGeoException;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.math.MathUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.conversions.IteratorIterable;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllPairInPolygonFinder
extends BoundLinePairFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllPairInPolygonFinder.class);
    private PlainComponentFinder plainHoleFinder;
    private Collection<List<ImmutablePoint>> boundPolygons;

    public AllPairInPolygonFinder(List<ImmutablePoint> points) {
        super(points);
        this.plainHoleFinder = new PlainComponentFinder(points);
    }

    public AllPairInPolygonFinder(Collection<List<ImmutablePoint>> boundPolygons) {
        super(new LinkedList<ImmutablePoint>());
        for (List<ImmutablePoint> list : boundPolygons) {
            this.addAll(list);
        }
        this.boundPolygons = new LinkedList<List<ImmutablePoint>>(boundPolygons);
    }

    public AllPairInPolygonFinder(Collection<List<ImmutablePoint>> boundPolygons, ImmutablePoint newPoint) {
        super(new LinkedList<ImmutablePoint>());
        this.boundPolygons = new LinkedList<List<ImmutablePoint>>();
        for (List<ImmutablePoint> list : boundPolygons) {
            this.addAll(list);
            this.boundPolygons.add(new LinkedList<ImmutablePoint>(list));
        }
        Double tolerance = 1.0E-4 * newPoint.getCoordinateFactory().getRefScale();
        block1: for (List<ImmutablePoint> list : this.boundPolygons) {
            ListIterator<ImmutablePoint> iter = list.listIterator();
            ImmutablePoint o = iter.next();
            while (iter.hasNext()) {
                ImmutablePoint p = iter.next();
                if (GeoUtils.isPointOnLine(newPoint, o, p, tolerance)) {
                    iter.previous();
                    iter.add(newPoint);
                    break block1;
                }
                o = p;
            }
        }
    }

    @Override
    protected int preCalcSteps(List<ImmutablePoint> points) {
        return MathUtil.littleGauss(1, points.size() - 1) + (this.plainHoleFinder == null ? 0 : this.plainHoleFinder.preCalcSteps());
    }

    @Override
    protected List<Tupel<ImmutablePoint, ImmutablePoint>> calculatePairs(List<ImmutablePoint> points) {
        if (this.boundPolygons == null) {
            this.plainHoleFinder.start(false);
            this.boundPolygons = (Collection)this.plainHoleFinder.getResult();
        }
        LinkedList<Tupel<ImmutablePoint, ImmutablePoint>> result = new LinkedList();
        try {
            for (List<ImmutablePoint> sPoints : this.boundPolygons) {
                if (sPoints.size() == 2) {
                    Iterator<ImmutablePoint> iter = sPoints.iterator();
                    result.add(new Tupel<ImmutablePoint, ImmutablePoint>(iter.next(), iter.next()));
                    continue;
                }
                if (sPoints.size() > 1000) {
                    throw new IllegalArgumentException("Too many points: " + sPoints.size());
                }
                result.addAll(this.calculateSinglePolygon(sPoints));
            }
        }
        catch (AbstractGeoException e) {
            result = super.calculatePairs(points);
        }
        return result;
    }

    private List<Tupel<ImmutablePoint, ImmutablePoint>> calculateSinglePolygon(List<ImmutablePoint> points) throws IllegalPointCountException {
        ImmutablePolygon polygon = ImmutableGeoObjectFactory.createImmutablePolygon(points);
        LinkedList<Tupel<ImmutablePoint, ImmutablePoint>> result = new LinkedList<Tupel<ImmutablePoint, ImmutablePoint>>();
        Iterator<ImmutablePoint> pointsIter = points.iterator();
        int index = 0;
        if (points.get(0).equals(points.get(points.size() - 1))) {
            ++index;
            pointsIter.next();
        }
        for (ImmutablePoint point : new IteratorIterable<ImmutablePoint>(pointsIter)) {
            ListIterator<ImmutablePoint> subIterator = points.listIterator(index + 1);
            while (subIterator.hasNext()) {
                ImmutablePoint subPoint = subIterator.next();
                ImmutableLineString lineString = ImmutableGeoObjectFactory.createImmutableLineString(point.getCoordinate(), subPoint.getCoordinate(), new Coordinate[0]);
                try {
                    if (polygon.covers(lineString)) {
                        result.add(new Tupel<ImmutablePoint, ImmutablePoint>(point, subPoint));
                    }
                }
                catch (TopologyException ex) {
                    ex.printStackTrace();
                }
                this.finishStep();
            }
            if (++index % 50 != 0) continue;
            LOGGER.debug("Index of AllPairPolygonFinder: " + index + "/" + points.size());
        }
        return result;
    }
}

