/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.pairfinder;

import de.datomino.util.algorithm.pairfinder.allinpolygon.AllPairInPolygonFinder;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.util.GeoUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.InputDataValidationException;
import org.ktde.util.datatypes.Tupel;

public class PairExtender
extends Algorithm {
    private Collection<ImmutablePolygon> polygons;
    private Collection<Tupel<ImmutablePoint, ImmutablePoint>> net;
    private Double tolerance;
    private Set<Tupel<ImmutablePoint, ImmutablePoint>> newPairs;
    private ImmutablePoint newPoint;
    private Boolean isSimilarPoint;
    private boolean newNetMode;

    public PairExtender(Collection<ImmutablePolygon> polygons, Collection<Tupel<ImmutablePoint, ImmutablePoint>> net, ImmutablePoint newPoint, Double tolerance) {
        this.polygons = polygons;
        this.net = net;
        this.newNetMode = !this.contains(polygons, newPoint);
        this.newPoint = newPoint;
        this.tolerance = tolerance;
    }

    private boolean contains(Collection<ImmutablePolygon> polygons2, ImmutablePoint newPoint2) {
        for (ImmutablePolygon polygon : this.polygons) {
            if (!polygon.contains(newPoint2)) continue;
            return true;
        }
        return false;
    }

    public PairExtender(Collection<ImmutablePolygon> polygons, Collection<Tupel<ImmutablePoint, ImmutablePoint>> net, List<ImmutablePoint> pointList, double percentage, Double tolerance) {
        this(polygons, net, GeoUtils.getPointOnLine(pointList, percentage), tolerance);
    }

    public PairExtender(Collection<ImmutablePolygon> polygons, Collection<Tupel<ImmutablePoint, ImmutablePoint>> net, ImmutablePoint start, ImmutablePoint end, double percentage, Double tolerance) {
        this(polygons, net, GeoUtils.getPointOnLine(start, end, percentage), tolerance);
    }

    @Override
    protected void perform() {
        this.finishStep();
        ImmutablePoint nearPoint = this.getNearPoint(this.newPoint);
        this.finishStep();
        if (nearPoint == null) {
            if (this.newNetMode) {
                LinkedList<List<ImmutablePoint>> polygonPoints = new LinkedList<List<ImmutablePoint>>();
                for (ImmutablePolygon poly : this.polygons) {
                    polygonPoints.add(poly.getShell().getCoordinates());
                }
                AllPairInPolygonFinder pairFinder = new AllPairInPolygonFinder(polygonPoints, this.newPoint);
                pairFinder.start(false);
                this.newPairs = new HashSet<Tupel<ImmutablePoint, ImmutablePoint>>();
                List<Tupel<ImmutablePoint, ImmutablePoint>> netA = pairFinder.getResult();
                for (Tupel<ImmutablePoint, ImmutablePoint> tupel : netA) {
                    Tupel<ImmutablePoint, ImmutablePoint> tupelI = tupel.reverse();
                    if (this.net.contains(tupel) || this.net.contains(tupelI)) continue;
                    this.newPairs.add(tupel);
                }
            } else {
                this.calculateNewNetTupels(this.newPoint);
            }
            this.isSimilarPoint = false;
        } else {
            this.newPoint = nearPoint;
            this.isSimilarPoint = true;
            this.newPairs = Collections.emptySet();
            this.finishTotal();
        }
    }

    @Override
    public int preCalcSteps() {
        return 2 + this.net.size();
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
    }

    private ImmutablePoint getNearPoint(ImmutablePoint point) {
        ImmutablePoint nearPoint = GeoUtils.findNearestPoint(point, new Iterator<ImmutablePoint>(){
            private Iterator<Tupel<ImmutablePoint, ImmutablePoint>> iterator;
            private boolean second;
            private Tupel<ImmutablePoint, ImmutablePoint> current;
            {
                this.iterator = PairExtender.this.net.iterator();
                this.second = false;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ImmutablePoint next() {
                ImmutablePoint point;
                if (this.second) {
                    point = this.current.getElement2();
                    this.second = false;
                } else {
                    this.current = this.iterator.next();
                    point = this.current.getElement1();
                    this.second = true;
                }
                return point;
            }

            @Override
            public boolean hasNext() {
                return this.second || this.iterator.hasNext();
            }
        }, this.tolerance);
        return nearPoint;
    }

    private void calculateNewNetTupels(ImmutablePoint point) {
        HashSet<ImmutablePoint> alreadyDone = new HashSet<ImmutablePoint>();
        LinkedHashSet<Tupel<ImmutablePoint, ImmutablePoint>> newPairTemp = new LinkedHashSet<Tupel<ImmutablePoint, ImmutablePoint>>();
        for (Tupel<ImmutablePoint, ImmutablePoint> tupel : this.net) {
            this.calculatePoint(point, tupel.getElement1(), alreadyDone, newPairTemp);
            this.calculatePoint(point, tupel.getElement2(), alreadyDone, newPairTemp);
            this.finishStep();
        }
        this.newPairs = newPairTemp;
    }

    private void calculatePoint(ImmutablePoint point, ImmutablePoint netPoint, Set<ImmutablePoint> alreadyDone, Set<Tupel<ImmutablePoint, ImmutablePoint>> newPairTemp) {
        if (!alreadyDone.contains(netPoint)) {
            alreadyDone.add(netPoint);
            ImmutableLineString lineString = ImmutableGeoObjectFactory.createImmutableLineString(new Coordinate[]{point.getCoordinate(), netPoint.getCoordinate()});
            boolean crosses = false;
            for (ImmutablePolygon polygon : this.polygons) {
                if (!lineString.crosses(polygon) && polygon.covers(lineString)) continue;
                crosses = true;
                break;
            }
            if (!crosses) {
                newPairTemp.add(new Tupel<ImmutablePoint, ImmutablePoint>(point, netPoint));
            }
        }
    }

    public Set<Tupel<ImmutablePoint, ImmutablePoint>> getNewPairs() {
        return this.newPairs;
    }

    public ImmutablePoint getNewPoint() {
        return this.newPoint;
    }

    public Boolean getIsSimilarPoint() {
        return this.isSimilarPoint;
    }
}

