/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.overlaping;

import de.datomino.util.algorithm.overlaping.AbstractOverlapingPolygonReducer;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.GeoUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.datatypes.Tupel;

public class ConvexHullOverlapingPolygonReducer<T>
extends AbstractOverlapingPolygonReducer<T> {
    private boolean ignoreInvalidPolygons;

    public static <T> ConvexHullOverlapingPolygonReducer<T> createConvexHullOverlapingPolygonReducer(Map<T, Collection<ImmutablePoint>> input, int maxDepth, boolean ignoreZeroPoints, boolean ignoreInvalidPolygons) {
        HashMap<T, Tupel<Collection<ImmutablePoint>, Object>> input2 = new HashMap<T, Tupel<Collection<ImmutablePoint>, Object>>();
        for (Map.Entry<T, Collection<ImmutablePoint>> entry : input.entrySet()) {
            input2.put(entry.getKey(), new Tupel<Collection<ImmutablePoint>, Object>(entry.getValue(), null));
        }
        return new ConvexHullOverlapingPolygonReducer(input2, maxDepth, ignoreZeroPoints, ignoreInvalidPolygons);
    }

    public static <T> ConvexHullOverlapingPolygonReducer<T> createConvexHullOverlapingPolygonReducerPre(Map<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> input, int maxDepth, boolean ignoreZeroPoints, boolean ignoreInvalidPolygons) {
        return new ConvexHullOverlapingPolygonReducer<T>(input, maxDepth, ignoreZeroPoints, ignoreInvalidPolygons);
    }

    protected ConvexHullOverlapingPolygonReducer(Map<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> input, int maxDepth, boolean ignoreZeroPoints, boolean ignoreInvalidPolygons) {
        super(input, maxDepth, ignoreZeroPoints);
        this.ignoreInvalidPolygons = ignoreInvalidPolygons;
    }

    @Override
    protected ImmutablePolygonKind createPolygon(Object key, Collection<ImmutablePoint> points) throws AlgorithmException {
        try {
            return GeoUtils.getConvexHull(points);
        }
        catch (IllegalPointCountException e) {
            if (this.ignoreInvalidPolygons) {
                return null;
            }
            throw new AlgorithmException(e);
        }
    }
}

