/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.componentfinder;

import de.datomino.util.algorithm.componentfinder.AbstractComponentFinder;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.GeoUtils;
import java.util.LinkedList;
import java.util.List;

public class PolygonComponentFinder
extends AbstractComponentFinder<ImmutablePolygon> {
    public PolygonComponentFinder(List<ImmutablePoint> points) {
        super(points);
    }

    @Override
    protected int preCalcAdditionalSteps(List<ImmutablePoint> points) {
        return points.size();
    }

    @Override
    protected ImmutablePolygon transformResult(List<List<ImmutablePoint>> componentPoints) {
        LinkedList<List<ImmutablePoint>> holePoints = new LinkedList<List<ImmutablePoint>>();
        List<ImmutablePoint> outerPoints = null;
        for (List<ImmutablePoint> componentPointList : componentPoints) {
            int size = componentPointList.size();
            if (size > 2) {
                if (GeoUtils.isClockwise(componentPointList)) {
                    holePoints.add(componentPointList);
                } else {
                    if (outerPoints != null) {
                        throw new IllegalArgumentException("only one point list is allowed to be counter-clockwise\n" + this.getFormattedComponentString(componentPoints));
                    }
                    outerPoints = componentPointList;
                }
            }
            this.finishSteps(size);
        }
        if (outerPoints == null) {
            throw new IllegalArgumentException("at least one point list must be counter-clockwise\n" + this.getFormattedComponentString(componentPoints));
        }
        try {
            return ImmutableGeoObjectFactory.createImmutablePolygon(outerPoints, holePoints);
        }
        catch (IllegalPointCountException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFormattedComponentString(List<List<ImmutablePoint>> componentPoints) {
        StringBuilder sb = new StringBuilder("[");
        for (List<ImmutablePoint> component : componentPoints) {
            sb.append("\n[");
            for (ImmutablePoint point : component) {
                sb.append("(").append(point.getX()).append(",").append(point.getY()).append(")");
            }
            sb.append("]");
        }
        sb.append("\n]");
        return sb.toString();
    }
}

