/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.componentfinder;

import de.datomino.util.geo.ImmutablePoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.InputDataValidationException;

public abstract class AbstractComponentFinder<T>
extends Algorithm {
    private List<ImmutablePoint> points;
    private T t;

    public AbstractComponentFinder(List<ImmutablePoint> points) {
        this.points = points;
    }

    @Override
    protected void perform() {
        List<List<ImmutablePoint>> componentPoints = this.createConsistentPolygons(this.points);
        this.t = this.transformResult(componentPoints);
    }

    protected abstract T transformResult(List<List<ImmutablePoint>> var1);

    protected abstract int preCalcAdditionalSteps(List<ImmutablePoint> var1);

    public T getResult() {
        return this.t;
    }

    @Override
    public int preCalcSteps() {
        return this.points.size() + this.preCalcAdditionalSteps(this.points);
    }

    private List<List<ImmutablePoint>> createConsistentPolygons(List<ImmutablePoint> points) {
        ArrayList<List<ImmutablePoint>> polygonPointList = new ArrayList<List<ImmutablePoint>>();
        Iterator<ImmutablePoint> iterator = points.iterator();
        Stack<ImmutablePoint> stack = new Stack<ImmutablePoint>();
        HashSet<ImmutablePoint> pointsInStack = new HashSet<ImmutablePoint>();
        while (iterator.hasNext()) {
            ImmutablePoint next = iterator.next();
            if (pointsInStack.add(next)) {
                stack.push(next);
            } else {
                LinkedList<ImmutablePoint> polygonPoints = new LinkedList<ImmutablePoint>();
                polygonPoints.add(next);
                ImmutablePoint popPoint = null;
                while (!next.equals(popPoint = (ImmutablePoint)stack.pop())) {
                    polygonPoints.add(0, popPoint);
                    pointsInStack.remove(popPoint);
                }
                stack.push(next);
                pointsInStack.add(next);
                if (polygonPoints.size() > 1) {
                    polygonPointList.add(polygonPoints);
                }
            }
            this.finishStep();
        }
        return polygonPointList;
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
    }
}

