/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.blockpartitioning.linewalker;

import de.datomino.util.algorithm.blockpartitioning.AbstractBlockPartitioner;
import de.datomino.util.algorithm.blockpartitioning.AbstractBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.BlockPartitionInputDto;
import de.datomino.util.algorithm.blockpartitioning.BoundPointsHolder;
import de.datomino.util.algorithm.blockpartitioning.DummyBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.GeomObjectHolder;
import de.datomino.util.algorithm.blockpartitioning.GreedyShortcutFinder;
import de.datomino.util.algorithm.blockpartitioning.RefPointDegenerationRemoverImpl;
import de.datomino.util.algorithm.blockpartitioning.linewalker.event.BoundPointStepChangedEvent;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.BasedPoint;
import de.datomino.util.geo.util.GeoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class LineWalkerBlockPartitioner
extends AbstractBlockPartitioner {
    public LineWalkerBlockPartitioner(BlockPartitionInputDto blockPartitionInputDto) {
        super(blockPartitionInputDto);
        this.setRefPointDegenerationRemover(new RefPointDegenerationRemoverImpl(this));
        this.setShortCutFinder(new GreedyShortcutFinder(this));
    }

    @Override
    protected Map<GeomObjectHolder, BoundPointsHolder> createPartitionsInternal(Map<GeomObjectHolder, BoundPointsHolder> map, List<GeomObjectHolder> geomObjectHolders, ImmutablePolygon boundingPolygon) {
        this.fireEvent(new BoundPointStepChangedEvent(this, map));
        HashMap<GeomObjectHolder, Tupel<ImmutablePolygon, Boolean>> boundPolygons = new HashMap<GeomObjectHolder, Tupel<ImmutablePolygon, Boolean>>();
        Iterator<GeomObjectHolder> iterator = geomObjectHolders.iterator();
        while (iterator.hasNext()) {
            ImmutablePolygon immutablePolygon;
            GeomObjectHolder geomObjectHolder;
            boundPolygons.put(geomObjectHolder, new Tupel<ImmutablePolygon, Boolean>(immutablePolygon, (immutablePolygon = this.createPolygon(geomObjectHolder = iterator.next(), map.get(geomObjectHolder))) == null));
        }
        while (!this.hasOnlyCutFree(boundPolygons, geomObjectHolders)) {
            for (GeomObjectHolder geomObjectHolder : geomObjectHolders) {
                Tupel tupel = (Tupel)boundPolygons.get(geomObjectHolder);
                boolean alreadyCutFree = (Boolean)tupel.getElement2();
                if (alreadyCutFree) continue;
                ImmutablePoint nearestPoint = this.calculateDeepestCut(map, geomObjectHolder, geomObjectHolders, boundPolygons);
                if (nearestPoint == null) {
                    tupel.setElement2(true);
                    continue;
                }
                this.insertPoint(map, geomObjectHolder, nearestPoint);
                boundPolygons.put(geomObjectHolder, new Tupel<ImmutablePolygon, Boolean>(this.createPolygon(geomObjectHolder, map.get(geomObjectHolder)), false));
                this.fireEvent(new BoundPointStepChangedEvent(this, map));
            }
        }
        this.finishStep();
        return map;
    }

    private boolean hasOnlyCutFree(Map<GeomObjectHolder, Tupel<ImmutablePolygon, Boolean>> boundPolygons, List<GeomObjectHolder> geomObjectHolders) {
        for (GeomObjectHolder geomObjectHolder : geomObjectHolders) {
            if (boundPolygons.get(geomObjectHolder).getElement2().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void insertPoint(Map<GeomObjectHolder, BoundPointsHolder> map, GeomObjectHolder geomObjectHolder, ImmutablePoint point) {
        BasedPoint basedPoint = GeoUtils.getPointRelationDescription(geomObjectHolder.getLineString(), point);
        double distanceOnBase = basedPoint.getDistanceOnBaseline();
        BoundPointsHolder boundPointsHolder = map.get(geomObjectHolder);
        LinkedList<AbstractBoundPoint> newBoundPoints = new LinkedList<AbstractBoundPoint>();
        boolean found = false;
        for (AbstractBoundPoint boundPoint : boundPointsHolder.getBoundPoints()) {
            if (found || boundPoint.getLengthOnBaseLine() < distanceOnBase) {
                newBoundPoints.add(boundPoint);
                continue;
            }
            newBoundPoints.add(new DummyBoundPoint(basedPoint, DummyBoundPoint.Type.OTHER_LINE));
            newBoundPoints.add(boundPoint);
            found = true;
        }
        map.put(geomObjectHolder, new BoundPointsHolder(newBoundPoints, boundPointsHolder.getIndex()));
    }

    private ImmutablePoint calculateDeepestCut(Map<GeomObjectHolder, BoundPointsHolder> map, GeomObjectHolder currentGeomObjectHolder, List<GeomObjectHolder> geomObjectHolders, Map<GeomObjectHolder, Tupel<ImmutablePolygon, Boolean>> boundPolygons) {
        ImmutablePolygon currentPolygon = boundPolygons.get(currentGeomObjectHolder).getElement1();
        ImmutableLineString currentLineString = currentGeomObjectHolder.getLineString();
        double minDistance = Double.MAX_VALUE;
        ImmutablePoint nearestPoint = null;
        for (GeomObjectHolder otherGeomObjectHolder : geomObjectHolders) {
            if (otherGeomObjectHolder == currentGeomObjectHolder) continue;
            for (AbstractBoundPoint boundPoint : map.get(otherGeomObjectHolder).getBoundPoints()) {
                double distance;
                ImmutablePoint point = boundPoint.getPoint();
                if (!point.within(currentPolygon) || !((distance = point.distance(currentLineString)) < minDistance)) continue;
                minDistance = distance;
                nearestPoint = point;
            }
        }
        return nearestPoint;
    }

    private ImmutablePolygon createPolygon(GeomObjectHolder geomObjectHolder, BoundPointsHolder boundPointsHolder) {
        try {
            List<AbstractBoundPoint> list = boundPointsHolder.getBoundPoints();
            List<ImmutablePoint> baseLinePoints = geomObjectHolder.getPointsOnLineWithoutEndPoints();
            int baseLinePointSize = baseLinePoints.size();
            ArrayList<ImmutablePoint> points = new ArrayList<ImmutablePoint>(list.size() + baseLinePointSize);
            CollectionUtil.transform(list, points, AbstractBlockPartitioner.POINT_STRIP_TRANSFORMER);
            Collections.reverse(points);
            points.addAll(baseLinePoints);
            return ImmutableGeoObjectFactory.createImmutablePolygon(points);
        }
        catch (IllegalPointCountException e) {
            return null;
        }
    }

    @Override
    protected int preCalcStepsForCreatePartitionsInternal(BlockPartitionInputDto blockPartitionInputDto) {
        return 1;
    }
}

