/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.blockpartitioning;

import de.datomino.util.algorithm.blockpartitioning.AbstractBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.BlockPartitionInputDto;
import de.datomino.util.algorithm.blockpartitioning.BoundPointsHolder;
import de.datomino.util.algorithm.blockpartitioning.GeomObjectHolder;
import de.datomino.util.algorithm.blockpartitioning.RefPointDegenerationRemover;
import de.datomino.util.algorithm.blockpartitioning.RegularBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.linewalker.event.CutEvent;
import de.datomino.util.algorithm.blockpartitioning.linewalker.event.OutOfPolygonEvent;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.ktde.util.algorithm.AbstractSubAlgorithm;
import org.ktde.util.algorithm.Algorithm;

public class RefPointDegenerationRemoverImpl
extends AbstractSubAlgorithm<BlockPartitionInputDto>
implements RefPointDegenerationRemover {
    public RefPointDegenerationRemoverImpl(Algorithm algorithm) {
        super(algorithm);
    }

    @Override
    public Map<GeomObjectHolder, BoundPointsHolder> removeDegenerations(Map<GeomObjectHolder, BoundPointsHolder> map, ImmutablePolygon boundingPolygon) {
        LinkedHashMap<GeomObjectHolder, BoundPointsHolder> newMap = new LinkedHashMap<GeomObjectHolder, BoundPointsHolder>();
        for (Map.Entry<GeomObjectHolder, BoundPointsHolder> entry : map.entrySet()) {
            GeomObjectHolder key = entry.getKey();
            LinkedList<AbstractBoundPoint> newBoundPoints = new LinkedList<AbstractBoundPoint>();
            for (AbstractBoundPoint boundPoint : entry.getValue().getBoundPoints()) {
                if (boundPoint instanceof RegularBoundPoint) {
                    RegularBoundPoint regularBoundPoint = (RegularBoundPoint)boundPoint;
                    if (!this.checkRegularBoundPoint(regularBoundPoint, key, map, boundingPolygon)) continue;
                    newBoundPoints.add(boundPoint);
                    continue;
                }
                newBoundPoints.add(boundPoint);
            }
            newMap.put(key, new BoundPointsHolder(newBoundPoints, entry.getValue().getIndex()));
            this.finishStep();
        }
        return newMap;
    }

    private boolean checkRegularBoundPoint(RegularBoundPoint regularBoundPoint, GeomObjectHolder currentGeomObjectHolder, Map<GeomObjectHolder, BoundPointsHolder> map, ImmutablePolygon boundingPolygon) {
        ImmutablePoint point = regularBoundPoint.getPoint();
        if (boundingPolygon.contains(regularBoundPoint.getPoint())) {
            ImmutableLineString lineString = regularBoundPoint.getLineString();
            for (GeomObjectHolder geomObjectHolder : map.keySet()) {
                if (currentGeomObjectHolder == geomObjectHolder || !geomObjectHolder.getLineString().crosses(lineString)) continue;
                this.fireEvent(new CutEvent(this, geomObjectHolder.getLineString(), lineString));
                return false;
            }
            for (Map.Entry entry : map.entrySet()) {
                if (currentGeomObjectHolder == entry.getKey()) continue;
                for (AbstractBoundPoint otherPoint : ((BoundPointsHolder)entry.getValue()).getBoundPoints()) {
                    if (!(otherPoint instanceof RegularBoundPoint) || !lineString.crosses(((RegularBoundPoint)otherPoint).getLineString())) continue;
                    this.fireEvent(new CutEvent(this, ((RegularBoundPoint)otherPoint).getLineString(), lineString));
                    return false;
                }
            }
            return true;
        }
        this.fireEvent(new OutOfPolygonEvent(this, point, boundingPolygon));
        return false;
    }

    @Override
    public int preCalcSteps(BlockPartitionInputDto blockPartitionInputDto) {
        return blockPartitionInputDto.getBlockParts().size();
    }
}

