/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.blockpartitioning;

import com.vividsolutions.jts.geom.TopologyException;
import de.datomino.util.algorithm.blockpartitioning.AbstractBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.BlockPartitionInputDto;
import de.datomino.util.algorithm.blockpartitioning.BoundPointsHolder;
import de.datomino.util.algorithm.blockpartitioning.GeomObjectHolder;
import de.datomino.util.algorithm.blockpartitioning.RegularBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.ShortCutFinder;
import de.datomino.util.algorithm.blockpartitioning.linewalker.event.BoundPointStepChangedEvent;
import de.datomino.util.algorithm.blockpartitioning.linewalker.event.GeomEvent;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.algorithm.AbstractSubAlgorithm;
import org.ktde.util.algorithm.Algorithm;

public class GreedyShortcutFinder
extends AbstractSubAlgorithm<BlockPartitionInputDto>
implements ShortCutFinder {
    public GreedyShortcutFinder(Algorithm algorithm) {
        super(algorithm);
    }

    @Override
    public Map<GeomObjectHolder, BoundPointsHolder> findShortCuts(Map<GeomObjectHolder, BoundPointsHolder> map, ImmutablePolygon blockPolygon) {
        for (Map.Entry<GeomObjectHolder, BoundPointsHolder> entry : map.entrySet()) {
            GeomObjectHolder currentGeomObject = entry.getKey();
            List<AbstractBoundPoint> points = entry.getValue().getBoundPoints();
            TreeSet<Integer> deleteIndices = new TreeSet<Integer>();
            int index = 1;
            for (AbstractBoundPoint outerPoint : points) {
                int innerIndex;
                if (!deleteIndices.contains(index - 1) && (innerIndex = index + 1) <= points.size()) {
                    ListIterator<AbstractBoundPoint> innerIterator = points.listIterator(innerIndex);
                    while (innerIterator.hasNext()) {
                        ImmutableLineString shortCut;
                        AbstractBoundPoint innerPoint = (AbstractBoundPoint)innerIterator.next();
                        if (!deleteIndices.contains(innerIndex) && this.isShortCutable(shortCut = ImmutableGeoObjectFactory.createImmutableLineString(outerPoint.getPoint().getCoordinate(), innerPoint.getPoint().getCoordinate(), new Coordinate[0]), map, blockPolygon, currentGeomObject, deleteIndices)) {
                            TreeSet<Integer> deleteCandidateSet = new TreeSet<Integer>();
                            for (int i = index; i < innerIndex; ++i) {
                                deleteCandidateSet.add(i);
                            }
                            if (this.isInReducedPolygon(currentGeomObject, points, deleteIndices, deleteCandidateSet)) {
                                deleteIndices.addAll(deleteCandidateSet);
                            }
                        }
                        ++innerIndex;
                    }
                }
                ++index;
            }
            index = 0;
            Iterator<AbstractBoundPoint> iterator = points.iterator();
            iterator.next();
            Iterator iterator2 = deleteIndices.iterator();
            while (iterator2.hasNext()) {
                int deleteIndex = (Integer)iterator2.next();
                while (index < deleteIndex) {
                    iterator.next();
                    ++index;
                }
                iterator.remove();
                this.fireEvent(new BoundPointStepChangedEvent(this, map));
            }
            this.finishStep();
        }
        return map;
    }

    private boolean isShortCutable(ImmutableLineString shortCut, Map<GeomObjectHolder, BoundPointsHolder> map, ImmutablePolygon blockPolygon, GeomObjectHolder currentGeomObject, SortedSet<Integer> deleteIndices) {
        try {
            if (shortCut.within(blockPolygon)) {
                for (Map.Entry<GeomObjectHolder, BoundPointsHolder> entry : map.entrySet()) {
                    ImmutableLineString lineString;
                    GeomObjectHolder subGeomObject = entry.getKey();
                    if (subGeomObject.getLineString().crosses(shortCut)) {
                        return false;
                    }
                    boolean own = subGeomObject == currentGeomObject;
                    int count = 0;
                    LinkedList<Coordinate> coordinates = new LinkedList<Coordinate>();
                    for (AbstractBoundPoint point : entry.getValue().getBoundPoints()) {
                        RegularBoundPoint regularBoundPoint;
                        ImmutableLineString lineString2;
                        if (point instanceof RegularBoundPoint && (!own || !deleteIndices.contains(count)) && shortCut.crosses(lineString2 = ImmutableGeoObjectFactory.createImmutableLineString((regularBoundPoint = (RegularBoundPoint)point).getAnchorPoint().getCoordinate(), regularBoundPoint.getPoint().getCoordinate(), new Coordinate[0]))) {
                            return false;
                        }
                        coordinates.add(point.getPoint().getCoordinate());
                        ++count;
                    }
                    if (own || !shortCut.crosses(lineString = ImmutableGeoObjectFactory.createImmutableLineString(coordinates))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
        return false;
    }

    private boolean isInReducedPolygon(GeomObjectHolder currentGeomObject, List<AbstractBoundPoint> points, SortedSet<Integer> deleteIndices, SortedSet<Integer> deleteCandidateSet) {
        ImmutablePolygon polygon;
        List<ImmutablePoint> baseLinePoints = currentGeomObject.getPointsOnLineWithoutEndPoints();
        ArrayList<ImmutablePoint> newPolygonPoints = new ArrayList<ImmutablePoint>(points.size() + baseLinePoints.size());
        ArrayList<ImmutablePoint> deleteCandidatePoints = new ArrayList<ImmutablePoint>(deleteCandidateSet.size());
        int index = 0;
        for (AbstractBoundPoint point : points) {
            boolean candidate = deleteCandidateSet.contains(index);
            if (candidate) {
                deleteCandidatePoints.add(point.getPoint());
            } else if (!deleteIndices.contains(index)) {
                newPolygonPoints.add(point.getPoint());
            }
            ++index;
        }
        Collections.reverse(newPolygonPoints);
        newPolygonPoints.addAll(baseLinePoints);
        try {
            polygon = ImmutableGeoObjectFactory.createImmutablePolygon(newPolygonPoints);
        }
        catch (IllegalPointCountException e) {
            return false;
        }
        for (ImmutablePoint candidate : deleteCandidatePoints) {
            if (candidate.within(polygon) || candidate.touches(polygon)) continue;
            return false;
        }
        this.fireEvent(new GeomEvent((Object)this, polygon, Color.MAGENTA));
        return true;
    }

    @Override
    public int preCalcSteps(BlockPartitionInputDto t) {
        return t.getBlockParts().size();
    }
}

