/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util;

import de.datomino.util.Job;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;

public class JobQueue<T extends Job>
implements Runnable {
    private static final int DEFAULT_PARALLEL_THREADS = 4;
    private LinkedHashSet<T> queuedJobs;
    private volatile Thread runner;
    private Set<JobRunnerThread> currentJobs;
    private final Semaphore jobSlots;
    private volatile boolean shutdownInProgress = false;
    private volatile boolean threadFinished;
    private Object queueLock = new Object();
    private volatile Job nextJob;

    public JobQueue() {
        this(4);
    }

    public JobQueue(int parallelThreads) {
        this.queuedJobs = new LinkedHashSet();
        this.currentJobs = new LinkedHashSet<JobRunnerThread>();
        this.jobSlots = new Semaphore(parallelThreads);
        this.threadFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        if (this.shutdownInProgress) {
            this.threadFinished = true;
            return;
        }
        boolean tryOne = true;
        block11: while (tryOne) {
            object = this.queueLock;
            synchronized (object) {
                if (this.queuedJobs.isEmpty()) {
                    break;
                }
                Iterator iterator = this.queuedJobs.iterator();
                this.nextJob = (Job)iterator.next();
                iterator.remove();
            }
            boolean waitForSemaphore = true;
            while (waitForSemaphore) {
                try {
                    this.jobSlots.acquire();
                    waitForSemaphore = false;
                }
                catch (InterruptedException e) {
                    if (!this.shutdownInProgress) continue;
                    break block11;
                }
            }
            JobRunnerThread loaderThread = new JobRunnerThread(this.nextJob);
            loaderThread.start();
            Object object2 = this.queueLock;
            synchronized (object2) {
                this.currentJobs.add(loaderThread);
                this.nextJob = null;
            }
        }
        object = this.queueLock;
        synchronized (object) {
            this.threadFinished = true;
            this.startThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.threadFinished && !this.queuedJobs.isEmpty()) {
                this.threadFinished = false;
                this.runner = new Thread(this);
                this.runner.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueJob(T job) {
        Object object = this.queueLock;
        synchronized (object) {
            boolean doEnqueue;
            boolean bl = doEnqueue = !this.queuedJobs.contains(job) && !this.currentJobs.contains(job) && !job.equals(this.nextJob);
            if (doEnqueue) {
                this.queuedJobs.add(job);
                this.startThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueJobs(Collection<T> jobs) {
        Object object = this.queueLock;
        synchronized (object) {
            for (Job t : jobs) {
                this.enqueueJob(t);
            }
        }
    }

    public void join() {
        while (!this.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isEmpty() {
        return this.queuedJobs.isEmpty() && this.currentJobs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Job> clearQueuedJobs() {
        Object object = this.queueLock;
        synchronized (object) {
            ArrayList<Job> list = new ArrayList<Job>(this.queuedJobs);
            this.queuedJobs.clear();
            return list;
        }
    }

    protected Object getQueueLock() {
        return this.queueLock;
    }

    protected LinkedHashSet<T> getQueuedJobs() {
        return this.queuedJobs;
    }

    private class JobRunnerThread
    extends Thread {
        private Job job;

        private JobRunnerThread(Job job) {
            super(job.getName());
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success = false;
            Throwable throwable = null;
            try {
                this.job.run();
                success = this.job.success();
                if (!success) {
                    throwable = this.job.getException();
                }
            }
            catch (Throwable t) {
                throwable = t;
            }
            if (throwable != null) {
                throwable.printStackTrace();
            }
            Object object = JobQueue.this.queueLock;
            synchronized (object) {
                JobQueue.this.currentJobs.remove(this);
                JobQueue.this.jobSlots.release();
            }
        }
    }
}

