/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.osm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class OsmCacheCleaner {
    private static final byte[] BLUE;
    private static final String DEFAULT_REMOTE_MAP_HOST = "http://tile.openstreetmap.org/";

    public static void main(String[] args) throws IOException {
        File dir = args.length > 0 ? new File(args[0]) : new File(".");
        OsmCacheCleaner.walkDir(dir);
    }

    private static void walkDir(File dir) throws IOException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                OsmCacheCleaner.walkDir(file);
                continue;
            }
            if (!file.getName().endsWith(".png")) continue;
            OsmCacheCleaner.checkAndUpdateFile(file);
        }
    }

    private static void checkAndUpdateFile(File file) throws IOException {
        byte[] content = FileUtils.readFileToByteArray(file);
        if (Arrays.equals(BLUE, content)) {
            String name = file.getName();
            int y = Integer.parseInt(name.substring(0, name.length() - 4));
            File parent = file.getParentFile();
            int x = Integer.parseInt(parent.getName());
            int z = Integer.parseInt(parent.getParentFile().getName());
            String tileName = z + "/" + x + "/" + y + ".png";
            URL url = new URL(DEFAULT_REMOTE_MAP_HOST + tileName);
            try {
                InputStream in = url.openStream();
                byte[] nContent = IOUtils.toByteArray(in);
                if (Arrays.equals(BLUE, nContent)) {
                    System.out.println(tileName + " is still blue");
                } else {
                    System.out.println(tileName + " is updated");
                    FileUtils.writeByteArrayToFile(file, nContent);
                }
            }
            catch (FileNotFoundException ex) {
                System.out.println(tileName + " not found");
            }
        }
    }

    static {
        try {
            BLUE = IOUtils.toByteArray(OsmCacheCleaner.class.getResourceAsStream("/osm/t.png"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

