/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.maven.pomeditor;

import de.datomino.tools.maven.pomeditor.ArtifactDescriptor;
import de.datomino.tools.maven.pomeditor.PomSearcher;
import de.datomino.tools.maven.pomeditor.PomVersionExtractor;
import de.datomino.tools.maven.pomeditor.filter.ArtifactFilter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.xml.sax.SAXException;

public class PomWalker {
    private static final ArtifactFilter SNAPSHOT_FILTER = new ArtifactFilter(){

        @Override
        public boolean filter(ArtifactDescriptor artifactDescriptor) {
            return artifactDescriptor.getVersion().trim().toUpperCase().endsWith("SNAPSHOT");
        }
    };

    public static void walkPoms(File[] dirs) throws SAXException, IOException {
        Set<File> poms = PomSearcher.searchPoms(dirs);
        LinkedHashSet<ArtifactDescriptor> descriptors = new LinkedHashSet<ArtifactDescriptor>();
        for (File pom : poms) {
            descriptors.addAll(PomVersionExtractor.findFullQualifiedArtifacts(pom, SNAPSHOT_FILTER));
        }
        HashMap<ArtifactDescriptor, String> newVersions = new HashMap<ArtifactDescriptor, String>();
        for (ArtifactDescriptor artifactDescriptor : descriptors) {
            newVersions.put(artifactDescriptor, PomWalker.getNewVersion(artifactDescriptor));
        }
        for (File pom : poms) {
            PomVersionExtractor.replaceVersions(pom, newVersions);
        }
    }

    private static String getNewVersion(ArtifactDescriptor artifactDescriptor) throws IOException {
        System.out.println("-----------------------------------------------");
        System.out.print("Group-Id: ");
        System.out.println(artifactDescriptor.getGroupId());
        System.out.print("Artifact-Id: ");
        System.out.println(artifactDescriptor.getArtifactId());
        System.out.print("Current version: ");
        System.out.println(artifactDescriptor.getVersion());
        System.out.print("New version [");
        System.out.print(artifactDescriptor.getVersion());
        System.out.print("] : ");
        char c = (char)System.in.read();
        StringBuilder sb = new StringBuilder();
        while (c != '\n') {
            sb.append(c);
            c = (char)System.in.read();
        }
        String newVersion = sb.toString().trim();
        return newVersion.isEmpty() ? artifactDescriptor.getVersion() : newVersion;
    }
}

