/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.maven;

import de.datomino.tools.maven.PomVersionReplacer;
import de.datomino.tools.maven.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;

public class PomVersionReplacerFrame
extends JFrame {
    private static final long serialVersionUID = -9143976332931501896L;
    private JList dirs;
    private JTextField toBeReplaced;
    private JTextField toBeReplacedWith;
    private JButton add;
    private JButton remove;
    private JButton execute;

    private PomVersionReplacerFrame() {
        super("Pom Version Replacer");
        this.initialize();
    }

    private void initialize() {
        this.getContentPane().setLayout(new SpringLayout());
        this.toBeReplaced = new JTextField();
        this.toBeReplaced.setBorder(new TitledBorder("Version to be replaced"));
        this.getContentPane().add(this.toBeReplaced);
        this.toBeReplacedWith = new JTextField();
        this.toBeReplacedWith.setBorder(new TitledBorder("Version to be set"));
        this.getContentPane().add(this.toBeReplacedWith);
        this.dirs = new JList(new DefaultListModel());
        this.dirs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PomVersionReplacerFrame.this.remove.setEnabled(PomVersionReplacerFrame.this.dirs.getSelectedIndex() >= 0);
            }
        });
        JScrollPane scroll = new JScrollPane(this.dirs);
        scroll.setBorder(new TitledBorder("Directories"));
        this.getContentPane().add(scroll);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new FlowLayout());
        this.execute = new JButton(new AbstractAction("Replace"){
            private static final long serialVersionUID = 6135302948776906228L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)PomVersionReplacerFrame.this.dirs.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    String message;
                    ListElement element = (ListElement)model.getElementAt(i);
                    try {
                        List<File> files = PomVersionReplacer.walkFiles(element.getFile(), PomVersionReplacerFrame.this.toBeReplaced.getText(), PomVersionReplacerFrame.this.toBeReplacedWith.getText());
                        message = "Replacement successful:\n\n" + StringUtils.join(files, '\n');
                    }
                    catch (PomVersionReplacer.PomVersionReplacerException ex) {
                        message = ex.getMessage() + "\n\n" + StringUtils.join(ex.getFiles(), '\n');
                    }
                    JOptionPane.showMessageDialog(PomVersionReplacerFrame.this, message);
                }
            }
        });
        this.remove = new JButton(new AbstractAction("Remove"){
            private static final long serialVersionUID = 3787251342062656408L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = PomVersionReplacerFrame.this.dirs.getSelectedIndices();
                DefaultListModel model = (DefaultListModel)PomVersionReplacerFrame.this.dirs.getModel();
                for (int i = selected.length - 1; i >= 0; --i) {
                    model.removeElementAt(i);
                }
            }
        });
        this.remove.setEnabled(false);
        this.add = new JButton(new AbstractAction("Add"){
            private static final long serialVersionUID = 214758044092268843L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.setFileSelectionMode(1);
                fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "Directories";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory();
                    }
                });
                int d = fileChooser.showOpenDialog(PomVersionReplacerFrame.this);
                if (d == 0) {
                    DefaultListModel model = (DefaultListModel)PomVersionReplacerFrame.this.dirs.getModel();
                    model.addElement(new ListElement(fileChooser.getSelectedFile()));
                }
            }
        });
        panel2.add(this.execute);
        panel2.add(this.remove);
        panel2.add(this.add);
        panel.add((Component)panel2, "West");
        this.getContentPane().add(panel);
        SpringUtilities.makeCompactGrid(this.getContentPane(), 4, 1, 5, 5, 2, 2);
        this.pack();
        this.setVisible(true);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            System.exit(0);
        }
        super.processWindowEvent(e);
    }

    public static void main(String[] args) {
        new PomVersionReplacerFrame();
    }

    private static class ListElement {
        private File file;

        private ListElement(File file) {
            this.file = file;
        }

        public String toString() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }
    }
}

