/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class PomVersionReplacer {
    private static final FileFilter DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public static List<File> walkFiles(File dir, String toBeFound, String toBeReplacedWith) throws PomVersionReplacerException {
        ArrayList<File> files = new ArrayList<File>();
        try {
            PomVersionReplacer.walkFilesRek(dir, toBeFound, toBeReplacedWith, files);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PomVersionReplacerException(files, e);
        }
        return files;
    }

    private static void walkFilesRek(File dir, String toBeFound, String toBeReplacedWith, List<File> files) throws IOException {
        File[] dirs;
        File pom = new File(dir, "pom.xml");
        if (pom.exists()) {
            PomVersionReplacer.replaceVersionInPom(pom, toBeFound, toBeReplacedWith);
            files.add(pom);
        }
        for (File subDir : dirs = dir.listFiles(DIR_FILTER)) {
            PomVersionReplacer.walkFilesRek(subDir, toBeFound, toBeReplacedWith, files);
        }
    }

    private static void replaceVersionInPom(File pom, String toBeFound, String toBeReplacedWith) throws IOException {
        int index;
        String content = FileUtils.readFileToString(pom);
        StringBuilder sb = new StringBuilder();
        int sIndex = 0;
        while ((index = StringUtils.indexOfIgnoreCase(content, "<version>", sIndex)) >= 0) {
            sb.append(content.substring(sIndex, index)).append("<version>");
            int eIndex = StringUtils.indexOfIgnoreCase(content, "</version>", index += 9);
            String version = content.substring(index, eIndex);
            if (version.equals(toBeFound)) {
                version = toBeReplacedWith;
            }
            sb.append(version).append("</version>");
            sIndex = eIndex + 10;
        }
        sb.append(content.substring(sIndex));
        FileUtils.writeStringToFile(pom, sb.toString());
    }

    static class PomVersionReplacerException
    extends Exception {
        private static final long serialVersionUID = 4682788179796612006L;
        private List<File> files;

        private PomVersionReplacerException(List<File> files, IOException ex) {
            super(ex.getMessage(), ex);
            this.files = files;
        }

        public List<File> getFiles() {
            return this.files;
        }
    }
}

