/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag.transition.preprocessor;

import de.datomino.tools.database2.dag.transition.preprocessor.Preprocessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyReplacerPreprocessor
implements Preprocessor {
    private static final Pattern PATTERN = Pattern.compile("\\{(.*)\\}");
    private Map<String, String> replacements;

    public void setProperties(Iterator<String> propertyIterator) {
        this.replacements = new HashMap<String, String>();
        while (propertyIterator.hasNext()) {
            String key = propertyIterator.next();
            if (!propertyIterator.hasNext()) continue;
            String value = propertyIterator.next();
            this.replacements.put(key, value);
        }
    }

    @Override
    public String preprocess(String input) throws IOException {
        Matcher matcher = PATTERN.matcher(input);
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (matcher.find()) {
            int start = matcher.start();
            sb.append(input.substring(index, start));
            String key = matcher.group(1);
            String value = this.replacements.get(key);
            if (value == null) {
                sb.append(matcher.group());
            } else {
                sb.append(value);
            }
            index = matcher.end();
        }
        sb.append(input.substring(index, input.length()));
        return sb.toString();
    }
}

