/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag.transition.preprocessor;

import de.datomino.tools.database2.dag.transition.preprocessor.Preprocessor;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractEncodingPreprocessor
implements Preprocessor {
    @Override
    public String preprocess(String input) throws UnsupportedEncodingException {
        StringBuilder sb;
        block5: {
            sb = new StringBuilder();
            Matcher matcher = this.getPattern().matcher(input);
            String encoding = "UTF-8";
            int inputLength = input.length();
            Set<DisablingDescriptor> disablingDescriptors = this.getDisablingDescriptors();
            int index = 0;
            while (true) {
                int cIndex;
                matcher.region(index, inputLength);
                int nextMatch = matcher.find() ? matcher.start() : inputLength;
                int nextDisabling = inputLength;
                DisablingDescriptor disablingDescriptor = null;
                for (DisablingDescriptor iterDisablingDescriptor : disablingDescriptors) {
                    int nextOpen = input.indexOf(iterDisablingDescriptor.getOpener(), index);
                    if (nextOpen < 0 || nextOpen >= nextDisabling) continue;
                    nextDisabling = nextOpen;
                    disablingDescriptor = iterDisablingDescriptor;
                }
                if (nextMatch < nextDisabling) {
                    sb.append(new String(input.substring(index, nextMatch).getBytes(), encoding));
                    encoding = this.extractEncoding(matcher);
                    index = nextMatch + matcher.group().length();
                    continue;
                }
                if (disablingDescriptor == null) break;
                int subIndex = index + disablingDescriptor.getOpener().length();
                while (true) {
                    String possibleEscaper;
                    if ((cIndex = input.indexOf(disablingDescriptor.getCloser(), subIndex)) < 0) {
                        sb.append(new String(input.substring(index, inputLength).getBytes(), encoding));
                        break block5;
                    }
                    if (disablingDescriptor.getEscaper() == null || !(possibleEscaper = input.substring(Math.max(cIndex - disablingDescriptor.getEscaper().length(), 0), cIndex)).equals(disablingDescriptor.getEscaper())) break;
                    subIndex = cIndex + 1;
                }
                int nIndex = cIndex + disablingDescriptor.getCloser().length();
                sb.append(new String(input.substring(index, nIndex).getBytes(), encoding));
                index = nIndex;
            }
            sb.append(new String(input.substring(index, inputLength).getBytes(), encoding));
        }
        return sb.toString();
    }

    protected abstract Pattern getPattern();

    protected abstract String extractEncoding(Matcher var1);

    protected abstract Set<DisablingDescriptor> getDisablingDescriptors();

    protected static class DisablingDescriptor {
        private String opener;
        private String closer;
        private String escaper;

        public DisablingDescriptor(String opener, String closer, String escaper) {
            this.opener = opener;
            this.closer = closer;
            this.escaper = escaper;
        }

        public DisablingDescriptor(String opener, String closer) {
            this(opener, closer, null);
        }

        public DisablingDescriptor(String openerCloser) {
            this(openerCloser, openerCloser);
        }

        public String getOpener() {
            return this.opener;
        }

        public String getCloser() {
            return this.closer;
        }

        public String getEscaper() {
            return this.escaper;
        }
    }
}

