/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag.transition.java;

import de.datomino.tools.database2.FeatureDatabaseDescriptor;
import de.datomino.tools.database2.dag.transition.java.JavaTransitionTask;
import de.datomino.tools.database2.log.DatabaseLog;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ktde.util.StringUtil;

public abstract class AbstractJavaTranistionTask
implements JavaTransitionTask {
    protected Long getNextId(String sequenceName, Connection con, FeatureDatabaseDescriptor featureDatabaseDescriptor, DatabaseLog databaseLog) throws SQLException {
        Statement stat = con.createStatement();
        String sql = "SELECT nextval('" + sequenceName + "') AS n;";
        databaseLog.info("Executing: " + sql);
        ResultSet rs = stat.executeQuery(sql);
        rs.next();
        Long next = rs.getLong("n");
        rs.close();
        stat.close();
        return next;
    }

    protected void insert(String tablename, Map<String, String> values, Connection con, FeatureDatabaseDescriptor featureDatabaseDescriptor, DatabaseLog databaseLog) throws SQLException {
        if (!values.containsKey("version")) {
            values.put("version", "0");
        }
        if (!values.containsKey("creation_date")) {
            values.put("creation_date", "CURRENT_TIMESTAMP");
        }
        if (!values.containsKey("last_modified_date")) {
            values.put("last_modified_date", "CURRENT_TIMESTAMP");
        }
        String sql = "INSERT INTO " + tablename + " (";
        ArrayList<String> cols = new ArrayList<String>(values.size());
        ArrayList<String> valueList = new ArrayList<String>(values.size());
        for (Map.Entry<String, String> entry : values.entrySet()) {
            cols.add(entry.getKey());
            valueList.add(entry.getValue());
        }
        sql = sql + StringUtil.implode(cols, ", ") + ") VALUES (" + StringUtil.implode(valueList, ", ") + ");";
        Statement stat = con.createStatement();
        databaseLog.info("Executing: " + sql);
        stat.execute(sql);
        stat.close();
    }

    protected String getBooleanValue(Boolean b, FeatureDatabaseDescriptor featureDatabaseDescriptor) {
        String dialect = featureDatabaseDescriptor.getDialect();
        if (dialect.toLowerCase().equals("db2")) {
            if (b == null) {
                return "NULL";
            }
            if (b.booleanValue()) {
                return "1";
            }
            return "0";
        }
        if (b == null) {
            return "NULL";
        }
        if (b.booleanValue()) {
            return "true";
        }
        return "false";
    }

    protected void dropIndex(Connection con, FeatureDatabaseDescriptor featureDatabaseDescriptor, DatabaseLog databaseLog, String index) throws SQLException {
        boolean db2 = featureDatabaseDescriptor.getDialect().equalsIgnoreCase("db2");
        Statement stat = con.createStatement();
        try {
            String sql = "DROP INDEX " + (featureDatabaseDescriptor.getDialect().equalsIgnoreCase("db2") ? "" : "IF EXISTS ") + index;
            if (!db2) {
                sql = sql + ";";
            }
            databaseLog.info(new Date() + " - Executing: " + sql);
            stat.execute(sql);
        }
        catch (SQLException e) {
            databaseLog.warn("Index " + index + " could not be dropped: " + e.getMessage());
        }
        stat.close();
    }

    protected void createIndex(Connection con, FeatureDatabaseDescriptor featureDatabaseDescriptor, DatabaseLog databaseLog, String index, String tablename, String[] columns) throws SQLException {
        boolean db2 = featureDatabaseDescriptor.getDialect().equalsIgnoreCase("db2");
        StringBuilder sb = new StringBuilder("CREATE INDEX ").append(index).append(" ON ").append(tablename);
        if (!db2) {
            sb.append(" USING btree");
        }
        sb.append(" (").append(StringUtil.implode(columns, ", ")).append(")");
        if (!db2) {
            sb.append(";");
        }
        Statement stat = con.createStatement();
        String sql = sb.toString();
        databaseLog.info(new Date() + " - Executing: " + sql);
        stat.execute(sql);
        stat.close();
    }

    @Override
    public String getSpecialMessageBeforeExecution(FeatureDatabaseDescriptor featureDatabaseDescriptor, List<String> args) {
        return null;
    }
}

