/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag.transition;

import de.datomino.tools.database2.FeatureDatabaseDescriptor;
import de.datomino.tools.database2.dag.transition.AbstractTransition;
import de.datomino.tools.database2.dag.transition.preprocessor.PostgresqlEncodingPreprocessor;
import de.datomino.tools.database2.dag.transition.preprocessor.Preprocessor;
import de.datomino.tools.database2.dag.transition.preprocessor.PropertyReplacerPreprocessor;
import de.datomino.tools.database2.exception.DatabaseToolException;
import de.datomino.tools.database2.log.DatabaseLog;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.ktde.util.StringUtil;

public class SqlTransition
extends AbstractTransition {
    private Map<String, List<? extends Preprocessor>> preprocessorMap;
    private PropertyReplacerPreprocessor propertyReplacerPreprocessor;

    public SqlTransition(List<String> args, DatabaseLog databaseLog) {
        super(args, databaseLog);
        HashMap map = new HashMap();
        ArrayList<Preprocessor> list = new ArrayList<Preprocessor>(2);
        list.add(new PostgresqlEncodingPreprocessor());
        this.propertyReplacerPreprocessor = new PropertyReplacerPreprocessor();
        list.add(this.propertyReplacerPreprocessor);
        map.put("postgresql", list);
        this.preprocessorMap = Collections.unmodifiableMap(map);
    }

    @Override
    protected boolean executeInternal(FeatureDatabaseDescriptor descriptor, Connection con) throws DatabaseToolException {
        File dir;
        List<String> args = this.getArgs();
        if (args.isEmpty()) {
            throw new DatabaseToolException("Directory expected");
        }
        Iterator<String> iter = args.iterator();
        String dirAsString = iter.next();
        String sqlRootDirectory = descriptor.getSqlRootDirectory();
        if (!StringUtil.isBlank(sqlRootDirectory)) {
            dirAsString = sqlRootDirectory + "/" + dirAsString;
        }
        if (!(dir = new File(dirAsString)).exists() || !dir.isDirectory()) {
            throw new DatabaseToolException("Invalid directory: " + dir.getAbsolutePath());
        }
        try {
            List<File> files = this.searchForFiles(dir, descriptor);
            this.getDatabaseLog().info("Files to execute:");
            for (File file : files) {
                this.getDatabaseLog().info(file.getCanonicalPath());
            }
            if (this.askToContinue(descriptor)) {
                this.executeFiles(descriptor, con, iter, files);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new DatabaseToolException(e);
        }
    }

    protected void executeFiles(FeatureDatabaseDescriptor descriptor, Connection con, Iterator<String> iter, List<File> files) throws IOException, DatabaseToolException {
        String input = null;
        try {
            Statement stat = con.createStatement();
            for (File file : files) {
                this.getDatabaseLog().info("Executing " + file.getCanonicalPath());
                input = FileUtils.readFileToString(file, "UTF-8");
                List<? extends Preprocessor> preprocessors = this.preprocessorMap.get(descriptor.getDialect());
                if (preprocessors != null) {
                    this.propertyReplacerPreprocessor.setProperties(iter);
                    for (Preprocessor preprocessor : preprocessors) {
                        input = preprocessor.preprocess(input);
                    }
                }
                if (descriptor.getDialect().equals("db2")) {
                    this.executeDb2(stat, input, con);
                    continue;
                }
                this.executeStatement(stat, input, con);
            }
            stat.close();
        }
        catch (SQLException e) {
            if (input != null) {
                throw new DatabaseToolException(e.getMessage() + "\n\n" + input + "\n", e);
            }
            throw new DatabaseToolException(e);
        }
    }

    protected void executeStatement(Statement stat, String input, Connection con) throws SQLException {
        stat.execute(input);
    }

    protected void executeDb2(Statement stat, String input, Connection con) throws SQLException {
        String uInput = StringUtil.removeComments(input, "/*", "*/");
        uInput = StringUtil.removeEndOfLineComments(uInput, "--");
        StringBuilder sb = new StringBuilder();
        Character openQuote = null;
        for (int i = 0; i < uInput.length(); ++i) {
            char c = uInput.charAt(i);
            if (c == '\'' || c == '\"') {
                if (openQuote == null) {
                    openQuote = Character.valueOf(c);
                } else if (openQuote.charValue() == c) {
                    openQuote = null;
                }
                sb.append(c);
                continue;
            }
            if (c == '\n' && openQuote == null) {
                sb.append(" ");
                continue;
            }
            if (c == ';') {
                String sql = sb.toString();
                if (!sql.trim().isEmpty()) {
                    sql = this.changeReorgDb2(sql);
                    this.getDatabaseLog().info("[DB2] Executing Statement: " + sql);
                    this.executeStatement(stat, sql, con);
                }
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        String sql = sb.toString();
        if (!sql.trim().isEmpty()) {
            sql = this.changeReorgDb2(sql);
            this.getDatabaseLog().info("[DB2] Executing Statement: " + sql);
            this.executeStatement(stat, sql, con);
        }
    }

    private String changeReorgDb2(String sql) {
        String table;
        StringTokenizer st = new StringTokenizer(sql);
        String c = st.hasMoreTokens() ? st.nextToken() : null;
        String t = st.hasMoreTokens() ? st.nextToken() : null;
        String string = table = st.hasMoreTokens() ? st.nextToken() : null;
        if (c != null && t != null && table != null && c.equalsIgnoreCase("reorg") && t.equalsIgnoreCase("table") && !st.hasMoreTokens()) {
            return "CALL SYSPROC.ADMIN_CMD ('" + sql + "')";
        }
        return sql;
    }

    private List<File> searchForFiles(File dir, FeatureDatabaseDescriptor descriptor) throws IOException, DatabaseToolException {
        this.getDatabaseLog().info("Searching directory " + dir.getCanonicalPath());
        String dialect = descriptor.getDialect();
        File subDir = new File(dir, dialect);
        if (!subDir.exists() || !subDir.isDirectory()) {
            this.getDatabaseLog().warn("No directory for dialect " + dialect + " found");
            subDir = new File(dir, "default");
            if (!subDir.exists() || !subDir.isDirectory()) {
                throw new DatabaseToolException("New valid directory found in dir " + dir.getAbsolutePath() + " for dialect " + descriptor.getDialect());
            }
        }
        this.getDatabaseLog().info("Using directory " + subDir.getCanonicalPath() + " as root");
        return this.searchForFilesRek(subDir, new ArrayList<File>());
    }

    private List<File> searchForFilesRek(File dir, List<File> fileList) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(".sql");
            }
        });
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (File file : files) {
            if (file.isDirectory()) {
                this.searchForFilesRek(file, fileList);
                continue;
            }
            fileList.add(file);
        }
        return fileList;
    }
}

