/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag.transition;

import de.datomino.tools.database2.FeatureDatabaseDescriptor;
import de.datomino.tools.database2.dag.transition.AbstractTransition;
import de.datomino.tools.database2.dag.transition.java.JavaTransitionTask;
import de.datomino.tools.database2.exception.DatabaseToolException;
import de.datomino.tools.database2.log.DatabaseLog;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import org.ktde.util.StringUtil;

public class JavaTransition
extends AbstractTransition {
    public JavaTransition(List<String> args, DatabaseLog databaseLog) {
        super(args, databaseLog);
    }

    @Override
    protected boolean executeInternal(FeatureDatabaseDescriptor descriptor, Connection con) throws DatabaseToolException {
        try {
            List<String> args = this.getArgs();
            String className = args.get(0);
            Class<?> clazz = Class.forName(className);
            JavaTransitionTask javaTransitionTask = (JavaTransitionTask)clazz.newInstance();
            this.getDatabaseLog().info("Executing class " + className + " with params [" + StringUtil.implode(args.subList(1, args.size()), ", ") + "]");
            String specialMessage = javaTransitionTask.getSpecialMessageBeforeExecution(descriptor, args);
            if (!StringUtil.isBlank(specialMessage)) {
                this.getDatabaseLog().info(specialMessage);
            }
            if (this.askToContinue(descriptor)) {
                return javaTransitionTask.execute(con, descriptor, this.getDatabaseLog(), args);
            }
            return false;
        }
        catch (InstantiationException e) {
            throw new DatabaseToolException(e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseToolException(e);
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseToolException(e);
        }
        catch (IOException e) {
            throw new DatabaseToolException(e);
        }
    }
}

