/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag.transition;

import de.datomino.tools.database2.FeatureDatabaseDescriptor;
import de.datomino.tools.database2.dag.transition.AbstractTransition;
import de.datomino.tools.database2.exception.DatabaseToolException;
import de.datomino.tools.database2.log.DatabaseLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.ktde.util.io.CsvReader;

public class CsvImportTransition
extends AbstractTransition {
    public CsvImportTransition(List<String> args, DatabaseLog databaseLog) {
        super(args, databaseLog);
    }

    @Override
    protected boolean executeInternal(FeatureDatabaseDescriptor descriptor, Connection con) throws DatabaseToolException {
        Iterator<String> iter = this.getArgs().iterator();
        Type type = Type.valueOf(iter.next());
        String filename = iter.next();
        String table = iter.next();
        String next = iter.next();
        ArrayList<String> idFields = null;
        switch (type) {
            case UPDATE: 
            case UPSERT: {
                idFields = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(next, ", \t");
                while (st.hasMoreTokens()) {
                    idFields.add(st.nextToken());
                }
                next = iter.next();
            }
        }
        LinkedHashMap<String, String> columnToColumn = new LinkedHashMap<String, String>();
        do {
            String[] mapping = next.split(":");
            columnToColumn.put(mapping[0], mapping[1]);
        } while (iter.hasNext() && (next = iter.next()) != null);
        try {
            CsvReader csvReader = new CsvReader(filename);
            List<String> header = csvReader.readLine();
            Map<String, Integer> headerMap = CsvReader.getHeaderMapping(header);
            List<String> line = csvReader.readLine();
            while (line != null) {
                boolean insert;
                switch (type) {
                    case UPSERT: {
                        ResultSet rs = this.performSelect(table, idFields, line, headerMap, columnToColumn, con);
                        rs.next();
                        int c = rs.getInt("c");
                        rs.close();
                        if (c == 0) {
                            insert = true;
                            break;
                        }
                        if (c == 1) {
                            insert = false;
                            break;
                        }
                        throw new DatabaseToolException("Multiple rows with id found");
                    }
                    case INSERT: {
                        insert = true;
                        break;
                    }
                    case UPDATE: {
                        insert = false;
                        break;
                    }
                    default: {
                        throw new DatabaseToolException();
                    }
                }
                if (!insert) continue;
                this.performInsert(table, idFields, line, headerMap, columnToColumn, con);
            }
        }
        catch (FileNotFoundException e) {
            throw new DatabaseToolException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new DatabaseToolException(e);
        }
        catch (IOException e) {
            throw new DatabaseToolException(e);
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e);
        }
        return false;
    }

    private void performInsert(String table, List<String> idFields, List<String> line, Map<String, Integer> headerMap, Map<String, String> columnToColumn, Connection con) {
        StringBuilder sb = new StringBuilder("INSERT INTO ").append(table).append("(").append(StringUtils.join(columnToColumn.values(), ',')).append(") VALUES (");
        sb.toString();
    }

    private ResultSet performSelect(String table, List<String> idFields, List<String> line, Map<String, Integer> headerMap, Map<String, String> columnToColumn, Connection con) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT count(*) as c from ").append(table).append(" WHERE ");
        Iterator<String> idIterator = idFields.iterator();
        String idField = columnToColumn.get(idIterator.next());
        sb.append(idField).append(" = ? ");
        while (idIterator.hasNext()) {
            idField = columnToColumn.get(idIterator.next());
            sb.append("AND ").append(idField).append(" = ? ");
        }
        sb.append(";");
        PreparedStatement stat = con.prepareStatement(sb.toString());
        int count = 1;
        for (String id : idFields) {
            String value = line.get(headerMap.get(columnToColumn.get(id)));
            stat.setObject(count, value);
            ++count;
        }
        return stat.executeQuery();
    }

    private static enum Type {
        INSERT,
        UPDATE,
        UPSERT;

    }
}

