/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag;

import de.datomino.tools.database2.dag.Dag;
import de.datomino.tools.database2.dag.DagException;
import de.datomino.tools.database2.dag.transition.AbstractTransition;
import de.datomino.tools.database2.dag.transition.CommandLineSqlTransition;
import de.datomino.tools.database2.dag.transition.EmptyTransition;
import de.datomino.tools.database2.dag.transition.IgnoringErrorSqlTransition;
import de.datomino.tools.database2.dag.transition.JavaTransition;
import de.datomino.tools.database2.dag.transition.SqlTransition;
import de.datomino.tools.database2.log.DatabaseLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.ktde.util.StringUtil;

public class DagBuilder {
    private static final Map<String, Class<? extends AbstractTransition>> TRANSITION_MAP;

    public static Map<String, Dag> buildDagFromSimpleFormat(File directory, DatabaseLog databaseLog) throws IOException, DagException {
        HashMap<String, Dag> dags = new HashMap<String, Dag>();
        DagBuilder.buildDagFromSimpleFormat(dags, directory, databaseLog);
        return dags;
    }

    private static void buildDagFromSimpleFormat(Map<String, Dag> dags, File directory, DatabaseLog databaseLog) throws FileNotFoundException, IOException, DagException {
        File[] featureFiles;
        for (File file : featureFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.isFile() && pathname.getName().endsWith(".feature");
            }
        })) {
            if (file.isDirectory()) {
                DagBuilder.buildDagFromSimpleFormat(dags, file, databaseLog);
                continue;
            }
            Dag dag = DagBuilder.readDagFromFile(file, databaseLog);
            dags.put(dag.getName(), dag);
        }
    }

    private static Dag readDagFromFile(File file, DatabaseLog databaseLog) throws FileNotFoundException, IOException, DagException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        Set<String> must = null;
        Set<String> mustNot = null;
        Set<String> insert = null;
        Set<String> remove = null;
        StringBuilder content = new StringBuilder();
        while (line != null) {
            String prefix = null;
            if (must == null) {
                prefix = "MUST";
            } else if (mustNot == null) {
                prefix = "MUSTNOT";
            } else if (insert == null) {
                prefix = "INSERT";
            } else if (remove == null) {
                prefix = "REMOVE";
            } else {
                content.append(line).append("\n");
            }
            if (prefix != null && !(line = line.trim()).startsWith("#") && !StringUtil.isBlank(line)) {
                line = line.split("#")[0];
                Set<String> featureSet = DagBuilder.readSet(prefix, line);
                if (must == null) {
                    must = featureSet;
                } else if (mustNot == null) {
                    mustNot = featureSet;
                } else if (insert == null) {
                    insert = featureSet;
                } else if (remove == null) {
                    remove = featureSet;
                }
            }
            line = br.readLine();
        }
        String filename = file.getName();
        Dag dag = new Dag(filename.substring(0, filename.length() - 8), must, mustNot, DagBuilder.parseContent(content.toString(), databaseLog), insert, remove);
        dag.getTransition().setDag(dag);
        return dag;
    }

    private static AbstractTransition parseContent(String content, DatabaseLog databaseLog) {
        if (StringUtil.isBlank(content)) {
            List<String> args = Collections.emptyList();
            return new EmptyTransition(args, databaseLog);
        }
        StringTokenizer st = new StringTokenizer(content, "\n");
        Class<? extends AbstractTransition> clazz = null;
        ArrayList<String> args = new ArrayList<String>();
        block6: while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (line.startsWith("#")) continue;
            line = line.split("#")[0];
            StringTokenizer subSt = new StringTokenizer(line);
            while (subSt.hasMoreTokens()) {
                String token = subSt.nextToken();
                if (clazz == null) {
                    clazz = TRANSITION_MAP.get(token);
                    if (clazz != null) continue;
                    break block6;
                }
                args.add(token);
            }
        }
        if (clazz != null) {
            try {
                return (AbstractTransition)clazz.getConstructor(List.class, DatabaseLog.class).newInstance(args, databaseLog);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Unknown content: " + content);
    }

    private static Set<String> readSet(String prefix, String line) throws DagException {
        StringTokenizer st = new StringTokenizer(line);
        String firstToken = st.nextToken();
        if (!prefix.equalsIgnoreCase(firstToken)) {
            throw new DagException(prefix + " expected");
        }
        HashSet<String> features = new HashSet<String>();
        while (st.hasMoreTokens()) {
            features.add(st.nextToken());
        }
        return features;
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("SQL", SqlTransition.class);
        map.put("COMMANDSQL", CommandLineSqlTransition.class);
        map.put("JAVA", JavaTransition.class);
        map.put("IGNORING_ERROR_SQL", IgnoringErrorSqlTransition.class);
        TRANSITION_MAP = Collections.unmodifiableMap(map);
    }
}

