/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag;

import de.datomino.tools.database2.dag.DagVisitor;
import de.datomino.tools.database2.dag.transition.AbstractTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Dag {
    private String name;
    private Set<String> featuresMustBeSet;
    private Set<String> featuresMustNotBeSet;
    private AbstractTransition transition;
    private Set<String> toBeSet;
    private Set<String> toBeDeleted;
    private List<Dag> children = new ArrayList<Dag>();
    private List<Dag> parents = new ArrayList<Dag>();

    public Dag(String name, Set<String> featuresMustBeSet, Set<String> featuresMustNotBeSet, AbstractTransition transition, Set<String> toBeSet, Set<String> toBeDeleted) {
        this.name = name;
        this.featuresMustBeSet = Collections.unmodifiableSet(featuresMustBeSet);
        this.featuresMustNotBeSet = Collections.unmodifiableSet(featuresMustNotBeSet);
        this.transition = transition;
        this.toBeSet = Collections.unmodifiableSet(toBeSet);
        this.toBeDeleted = Collections.unmodifiableSet(toBeDeleted);
    }

    public void addChild(Dag dag) {
        this.children.add(dag);
        dag.addParent(this);
    }

    public void addChildren(Collection<Dag> children) {
        this.children.addAll(children);
    }

    private void addParent(Dag dag) {
        this.parents.add(dag);
    }

    public List<Dag> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public List<Dag> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public void traverseTopDown(DagVisitor visitor) {
        if (!visitor.visit(this)) {
            for (Dag child : this.children) {
                child.traverseTopDown(visitor);
            }
        }
    }

    public void traverseBottomUp(DagVisitor visitor) {
        if (!visitor.visit(this)) {
            for (Dag parent : this.parents) {
                parent.traverseBottomUp(visitor);
            }
        }
    }

    public boolean satisfiesCondition(Set<String> setFeautres) {
        for (String feature : this.featuresMustBeSet) {
            if (setFeautres.contains(feature)) continue;
            return false;
        }
        for (String feature : this.featuresMustNotBeSet) {
            if (!setFeautres.contains(feature)) continue;
            return false;
        }
        return true;
    }

    public Set<String> getFeaturesMustBeSet() {
        return this.featuresMustBeSet;
    }

    public Set<String> getFeaturesMustNotBeSet() {
        return this.featuresMustNotBeSet;
    }

    public AbstractTransition getTransition() {
        return this.transition;
    }

    public Set<String> getToBeSet() {
        return this.toBeSet;
    }

    public Set<String> getToBeDeleted() {
        return this.toBeDeleted;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dag) {
            Dag other = (Dag)obj;
            return new EqualsBuilder().append(this.getName(), other.getName()).append(this.getFeaturesMustBeSet(), other.getFeaturesMustBeSet()).append(this.getFeaturesMustNotBeSet(), other.getFeaturesMustNotBeSet()).append(this.getToBeSet(), other.getToBeSet()).append(this.getToBeDeleted(), other.getToBeDeleted()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getName()).append(this.getFeaturesMustBeSet()).append(this.getFeaturesMustNotBeSet()).append(this.getToBeSet()).append(this.getToBeDeleted()).toHashCode();
    }

    public String toString() {
        return this.getName();
    }
}

