/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2;

import de.datomino.tools.database2.log.DatabaseLog;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.ktde.util.StringUtil;

public class SimpleDatabaseDescriptor {
    private static final String DEFAULT_DB_DRIVER = "org.postgresql.Driver";
    private static final String DEFAULT_DB_HOST = "localhost";
    private static final int DEFAULT_DB_PORT = 5432;
    private static final String DEFAULT_DB_USER = "postgres";
    private static final String DEFAULT_DB_PASSWORD = "damassa";
    private static final String DEFAULT_DATABASE_DIALECT = "postgres";
    private static final String DEFAULT_PLAIN_DATABASE_PATTERN = "jdbc:%%%DIALECT%%%://%%%HOST%%%:%%%PORT%%%/";
    private static final String DEFAULT_DATABASE_PATTERN = "jdbc:%%%DIALECT%%%://%%%HOST%%%:%%%PORT%%%/%%%DATABASE%%%";
    private static final String DEFAULT_FEATURE_TABLE = "installed_features";
    private static final String DEFAULT_DATABASE_NAME = "test_database";
    private String driver;
    private String host;
    private Integer port;
    private String user;
    private String password;
    private String dialect;
    private String pattern;
    private String plainPattern;
    private String databaseName;
    private String featureTableName;

    public SimpleDatabaseDescriptor() {
    }

    public SimpleDatabaseDescriptor(Properties props, DatabaseLog databaseLog) {
        this.driver = this.getProperty(props, "driver", DEFAULT_DB_DRIVER, databaseLog);
        this.host = this.getProperty(props, "host", DEFAULT_DB_HOST, databaseLog);
        try {
            this.port = Integer.parseInt(this.getProperty(props, "port", Integer.toString(5432), databaseLog));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Port must be a number");
        }
        this.user = this.getProperty(props, "user", "postgres", databaseLog);
        this.password = this.getProperty(props, "password", DEFAULT_DB_PASSWORD, databaseLog);
        this.dialect = this.getProperty(props, "dialect", "postgres", databaseLog);
        this.databaseName = this.getProperty(props, "databaseName", DEFAULT_DATABASE_NAME, databaseLog);
        this.featureTableName = this.getProperty(props, "featureTableName", DEFAULT_FEATURE_TABLE, databaseLog);
        this.pattern = this.getProperty(props, "pattern", DEFAULT_DATABASE_PATTERN, databaseLog);
        this.plainPattern = this.getProperty(props, "plainPattern", DEFAULT_PLAIN_DATABASE_PATTERN, databaseLog);
    }

    public String getDriver() {
        return this.driver == null ? DEFAULT_DB_DRIVER : this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getHost() {
        return this.host == null ? DEFAULT_DB_HOST : this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port == null ? 5432 : this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUser() {
        return this.user == null ? "postgres" : this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password == null ? DEFAULT_DB_PASSWORD : this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDialect() {
        return this.dialect == null ? "postgres" : this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getPattern() {
        return this.pattern == null ? DEFAULT_DATABASE_PATTERN : this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getDatabaseName() {
        return this.databaseName == null ? DEFAULT_DATABASE_NAME : this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getFeatureTableName() {
        return this.featureTableName == null ? DEFAULT_FEATURE_TABLE : this.featureTableName;
    }

    public void setFeatureTableName(String featureTableName) {
        this.featureTableName = featureTableName;
    }

    public String getPlainPattern() {
        return this.plainPattern == null ? DEFAULT_PLAIN_DATABASE_PATTERN : this.plainPattern;
    }

    public void setPlainPattern(String plainPattern) {
        this.plainPattern = plainPattern;
    }

    protected String getPlainDatabaseConnectionString() {
        return this.replaceValuesInPattern(this.getPlainPattern());
    }

    public String getDatabaseConnectionString() {
        return this.replaceValuesInPattern(this.getPattern());
    }

    private String replaceValuesInPattern(String pattern) {
        return pattern.replaceAll("%%%HOST%%%", this.getHost()).replaceAll("%%%DIALECT%%%", this.getDialect()).replaceAll("%%%PORT%%%", this.getPort().toString()).replaceAll("%%%DATABASE%%%", this.getDatabaseName());
    }

    public Connection createConnection() throws SQLException {
        return this.createConnection(this.getDatabaseConnectionString());
    }

    protected Connection createPlainConnection() throws SQLException {
        return this.createConnection(this.getPlainDatabaseConnectionString());
    }

    private Connection createConnection(String url) throws SQLException {
        Connection con = DriverManager.getConnection(url, this.getUser(), this.getPassword());
        con.setAutoCommit(false);
        return con;
    }

    protected String getProperty(Properties props, String name, String defValue, DatabaseLog databaseLog) {
        String value = props.getProperty(name);
        boolean def = false;
        if (value == null) {
            value = defValue;
            def = true;
        }
        this.logProperty(name, value, def, databaseLog);
        return value;
    }

    private void logProperty(String prop, String value, boolean def, DatabaseLog databaseLog) {
        StringBuilder sb = new StringBuilder("Using ");
        if (def) {
            sb.append("default ");
        }
        sb.append("value ").append(StringUtil.nullToEmpty(value)).append(" for property ").append(prop);
        databaseLog.info(sb.toString());
    }
}

