/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2;

import de.datomino.tools.database2.ConfirmationMode;
import de.datomino.tools.database2.SimpleDatabaseDescriptor;
import de.datomino.tools.database2.log.DatabaseLog;
import java.util.Properties;

public class FeatureDatabaseDescriptor
extends SimpleDatabaseDescriptor {
    private static final String DEFAULT_FEATURE_DIRECTORY = "./src/test/resources/features/";
    private static final ConfirmationMode DEFAULT_CONFIRMATION_MODE = ConfirmationMode.SINGLE;
    private static final String DEFAULT_SQL_COMMAND = "/usr/bin/psql";
    private static final String DEFAULT_SQL_COMMAND_PATTERN = "%%%SQL_COMMAND%%% -h %%%HOST%%% -p %%%PORT%%% -d %%%DATABASE%%% -U %%%USER%%% -f";
    private String featureDirectory;
    private ConfirmationMode confirmationMode;
    private String sqlCommand;
    private String sqlCommandPattern;
    private String sqlRootDirectory;

    public FeatureDatabaseDescriptor() {
    }

    public FeatureDatabaseDescriptor(Properties props, DatabaseLog databaseLog) {
        super(props, databaseLog);
        this.featureDirectory = this.getProperty(props, "featureDirectory", DEFAULT_FEATURE_DIRECTORY, databaseLog);
        this.confirmationMode = ConfirmationMode.valueOf(this.getProperty(props, "confirmationMode", DEFAULT_CONFIRMATION_MODE.name(), databaseLog));
        this.sqlCommand = this.getProperty(props, "sqlCommand", DEFAULT_SQL_COMMAND, databaseLog);
        this.sqlCommandPattern = this.getProperty(props, "sqlCommandPattern", DEFAULT_SQL_COMMAND_PATTERN, databaseLog);
        this.sqlRootDirectory = this.getProperty(props, "sqlRootDirectory", null, databaseLog);
    }

    public String getFeatureDirectory() {
        return this.featureDirectory == null ? DEFAULT_FEATURE_DIRECTORY : this.featureDirectory;
    }

    public void setFeatureDirectory(String featureDirectory) {
        this.featureDirectory = featureDirectory;
    }

    public ConfirmationMode getConfirmationMode() {
        return this.confirmationMode == null ? DEFAULT_CONFIRMATION_MODE : this.confirmationMode;
    }

    public void setConfirmationMode(ConfirmationMode confirmationMode) {
        this.confirmationMode = confirmationMode;
    }

    public String getSqlCommand() {
        return this.sqlCommand;
    }

    public void setSqlCommand(String sqlCommand) {
        this.sqlCommand = sqlCommand;
    }

    public String getSqlCommandPattern() {
        return this.sqlCommandPattern;
    }

    public void setSqlCommandPattern(String sqlCommandPattern) {
        this.sqlCommandPattern = sqlCommandPattern;
    }

    public void setSqlRootDirectory(String sqlRootDirectory) {
        this.sqlRootDirectory = sqlRootDirectory;
    }

    public String getSqlRootDirectory() {
        return this.sqlRootDirectory;
    }

    public String getSqlCommandPrefix() {
        return this.getSqlCommandPattern().replace("%%%SQL_COMMAND%%%", this.getSqlCommand()).replace("%%%HOST%%%", this.getHost()).replace("%%%PORT%%%", this.getPort().toString()).replace("%%%DATABASE%%%", this.getDatabaseName()).replace("%%%USER%%%", this.getUser());
    }
}

