/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2;

import de.datomino.tools.database2.FeatureDatabaseDescriptor;
import de.datomino.tools.database2.dag.Dag;
import de.datomino.tools.database2.dag.DagBuilder;
import de.datomino.tools.database2.dag.DagCalculator;
import de.datomino.tools.database2.dag.DagException;
import de.datomino.tools.database2.exception.DatabaseToolException;
import de.datomino.tools.database2.log.DatabaseLog;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.util.StringUtil;
import org.springframework.util.ResourceUtils;

public class DatabaseTool {
    public static void executeUpdate(FeatureDatabaseDescriptor featureDatabaseDescriptor, String featurename, DatabaseLog databaseLog) throws SQLException, IOException, DagException, DatabaseToolException {
        block6: {
            List<String> installedFeatures = DatabaseTool.fetchInstalledFeatures(featureDatabaseDescriptor);
            File directory = ResourceUtils.getFile(featureDatabaseDescriptor.getFeatureDirectory());
            if (!directory.exists() || !directory.isDirectory()) {
                throw new DatabaseToolException(featureDatabaseDescriptor.getFeatureDirectory() + " is not a valid directory");
            }
            Map<String, Dag> dags = DagBuilder.buildDagFromSimpleFormat(directory, databaseLog);
            List<List<Dag>> ways = DagCalculator.calculateDags(dags.values(), new HashSet<String>(installedFeatures), featurename);
            DatabaseTool.printWays(ways, featurename, databaseLog);
            if (ways != null && !ways.isEmpty()) {
                if (ways.size() > 1) {
                    while (true) {
                        databaseLog.info("Please choose the way. (Press q to quit)");
                        char c = (char)System.in.read();
                        if (Character.toLowerCase(c) == 'q') {
                            return;
                        }
                        if (!Character.isDigit(c)) continue;
                        int i = Integer.parseInt(Character.toString(c));
                        if (i >= 1 && i <= ways.size()) {
                            List<Dag> way = ways.get(i - 1);
                            DatabaseTool.executeWay(way, featureDatabaseDescriptor);
                            break block6;
                        }
                        databaseLog.info("please choose between 1-" + ways.size());
                    }
                }
                DatabaseTool.executeWay(ways.get(0), featureDatabaseDescriptor);
            }
        }
    }

    private static void executeWay(List<Dag> way, FeatureDatabaseDescriptor featureDatabaseDescriptor) throws DatabaseToolException, SQLException {
        for (Dag dag : way) {
            if (!DatabaseTool.executeDag(featureDatabaseDescriptor, dag)) break;
        }
    }

    private static boolean executeDag(FeatureDatabaseDescriptor featureDatabaseDescriptor, Dag dag) throws DatabaseToolException, SQLException {
        boolean b;
        Connection con = featureDatabaseDescriptor.createConnection();
        Statement stat = con.createStatement();
        if (!featureDatabaseDescriptor.getDialect().equals("db2")) {
            stat.execute("BEGIN");
        }
        if (b = dag.getTransition().execute(featureDatabaseDescriptor, con)) {
            DatabaseTool.writeFeatures(dag.getToBeSet(), featureDatabaseDescriptor, con);
            DatabaseTool.deleteFeatures(dag.getToBeDeleted(), featureDatabaseDescriptor, con);
            con.commit();
        } else {
            con.rollback();
        }
        stat.close();
        con.close();
        return b;
    }

    private static void deleteFeatures(Set<String> toBeDeleted, FeatureDatabaseDescriptor featureDatabaseDescriptor, Connection con) throws SQLException {
        if (!toBeDeleted.isEmpty()) {
            PreparedStatement stat = con.prepareStatement("DELETE FROM t_" + featureDatabaseDescriptor.getFeatureTableName() + " WHERE (" + StringUtil.multiply("feature_name = ?", toBeDeleted.size(), " OR ") + ")");
            int count = 1;
            for (String feature : toBeDeleted) {
                stat.setString(count, feature);
                ++count;
            }
            stat.execute();
            stat.close();
        }
    }

    private static void writeFeatures(Set<String> toBeSet, FeatureDatabaseDescriptor featureDatabaseDescriptor, Connection con) throws SQLException {
        if (!toBeSet.isEmpty()) {
            String dialect = featureDatabaseDescriptor.getDialect();
            boolean db2 = "db2".equalsIgnoreCase(dialect);
            PreparedStatement select = con.prepareStatement("SELECT feature_name FROM " + (db2 ? "" : "public.") + "t_" + featureDatabaseDescriptor.getFeatureTableName() + " where feature_name = ?");
            PreparedStatement insert = con.prepareStatement("INSERT INTO " + (db2 ? "" : "public.") + "t_" + featureDatabaseDescriptor.getFeatureTableName() + " (feature_name) VALUES (?)");
            for (String feature : toBeSet) {
                select.setString(1, feature);
                ResultSet rs = select.executeQuery();
                if (!rs.next()) {
                    insert.setString(1, feature);
                    insert.execute();
                }
                rs.close();
            }
            select.close();
            insert.close();
        }
    }

    private static void printWays(List<List<Dag>> ways, String feature, DatabaseLog databaseLog) {
        if (ways == null) {
            databaseLog.warn("Feature " + feature + " already installed");
        } else if (ways.isEmpty()) {
            databaseLog.warn("No way found to feature " + feature);
        } else {
            databaseLog.info("Following ways were found:");
            int count = 1;
            for (List<Dag> way : ways) {
                StringBuilder sb = new StringBuilder();
                sb.append(count).append(": ");
                Iterator<Dag> iter = way.iterator();
                sb.append(iter.next().getName());
                while (iter.hasNext()) {
                    sb.append(", ").append(iter.next());
                }
                ++count;
                databaseLog.info(sb.toString());
            }
        }
    }

    private static List<String> fetchInstalledFeatures(FeatureDatabaseDescriptor featureDatabaseDescriptor) throws SQLException {
        Connection con = featureDatabaseDescriptor.createConnection();
        Statement stat = con.createStatement();
        String sql = "SELECT feature_name as fn FROM t_" + featureDatabaseDescriptor.getFeatureTableName();
        ResultSet rs = stat.executeQuery(sql);
        ArrayList<String> features = new ArrayList<String>();
        while (rs.next()) {
            features.add(rs.getString("fn"));
        }
        rs.close();
        stat.close();
        con.commit();
        con.close();
        return features;
    }
}

