/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.common;

import de.datomino.tools.common.CommandLineProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CommandLinePropertyParser {
    public static CommandLineProperties parseProperties(String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        HashMap<String, List<String>> switches = new HashMap<String, List<String>>();
        String currentSwitch = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                currentSwitch = arg.substring(1);
                switches.put(currentSwitch, new ArrayList());
                continue;
            }
            if (currentSwitch == null) {
                commands.add(arg);
                continue;
            }
            ((List)switches.get(currentSwitch)).add(arg);
        }
        return new CommandLineProperties(commands, switches);
    }

    public static CommandLineProperties parseProperties(String propertyString) {
        ArrayList<String> commands = new ArrayList<String>();
        HashMap<String, List<String>> switches = new HashMap<String, List<String>>();
        ArrayList<String> tokens = new ArrayList<String>();
        boolean quoteMode = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < propertyString.length(); ++i) {
            char c = propertyString.charAt(i);
            if (quoteMode || !Character.isWhitespace(c)) {
                switch (c) {
                    case '\"': {
                        if (quoteMode) {
                            tokens.add(sb.toString());
                            sb = new StringBuilder();
                            quoteMode = false;
                            break;
                        }
                        if (sb.length() > 0) {
                            tokens.add(sb.toString());
                            sb = new StringBuilder();
                        }
                        quoteMode = true;
                        break;
                    }
                    case '-': {
                        if (quoteMode) {
                            sb.append(c);
                            break;
                        }
                        if (sb.length() > 0) {
                            tokens.add(sb.toString());
                            sb = new StringBuilder();
                        }
                        tokens.add(null);
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            if (sb.length() <= 0) continue;
            tokens.add(sb.toString());
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            tokens.add(sb.toString());
        }
        boolean switchMode = false;
        String switchName = null;
        List switchParams = null;
        for (String token : tokens) {
            if (token == null) {
                if (switchMode && switchName != null) {
                    if (switchParams == null) {
                        switchParams = Collections.emptyList();
                    }
                    switches.put(switchName, switchParams);
                    switchName = null;
                    switchParams = null;
                }
                switchMode = true;
                continue;
            }
            if (switchMode) {
                if (switchName == null) {
                    switchName = token;
                    continue;
                }
                if (switchParams == null) {
                    switchParams = new ArrayList();
                }
                switchParams.add(token);
                continue;
            }
            commands.add(token);
        }
        return new CommandLineProperties(commands, switches);
    }
}

