/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.webportal.gui;

import com.google.protobuf.InvalidProtocolBufferException;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.exception.WebportalException;
import de.datomino.peppergis.webportal.WebportalUploadAreasReportDto;
import de.datomino.peppergis.webportal.gui.UserEditDialog;
import de.datomino.peppergis.webportal.proto.Webportal;
import de.datomino.util.swing.ExceptionMessageDialog;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.util.StringUtil;

public class WebportalControlDialog
extends CommonDialog {
    private static final long serialVersionUID = 7575600610156996441L;
    private JList orderList;
    private JList userList;
    private EditUserAction editUserAction;
    private ModelEnviroment modelEnviroment;
    private String webportalName;

    public WebportalControlDialog(Component parent, ModelEnviroment modelEnviroment, String webportalName) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.webportalcontrol.dialogTitle", new Serializable[]{webportalName}), Dialog.ModalityType.APPLICATION_MODAL);
        this.webportalName = webportalName;
        this.modelEnviroment = modelEnviroment;
        modelEnviroment.setParent(this);
        this.buildLayout();
        this.pack();
        SwingUtils.centerDialog(this, parent);
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 7410579362252828009L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WebportalControlDialog.this.dispose();
                WebportalControlDialog.this.modelEnviroment.close();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return null;
    }

    @Override
    protected Action[] getAdditionalActions() {
        Action[] setActions = super.getAdditionalActions();
        Action[] actions2 = new Action[1 + setActions.length];
        System.arraycopy(setActions, 0, actions2, 0, setActions.length);
        actions2[setActions.length] = new UploadAreaAction();
        return actions2;
    }

    @Override
    protected Component getMainComponent() {
        JPanel bigPanel = new JPanel(new SpringLayout());
        bigPanel.add(this.createOrderPanel());
        bigPanel.add(this.createUserPanel());
        SpringUtilities.makeCompactGrid(bigPanel, 1, 2, 5, 5, 5, 5);
        return bigPanel;
    }

    private JPanel createUserPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.user", new Serializable[0]));
        panel.add((Component)label, "North");
        DefaultListModel<Webportal.User> dlm = new DefaultListModel<Webportal.User>();
        try {
            byte[] usersByteArray = this.modelEnviroment.getAllCaller().getWebportalCaller().getAllUsers(this.webportalName);
            Webportal.UserList userList = Webportal.UserList.parseFrom(usersByteArray);
            for (Webportal.User user : userList.getUsersList()) {
                dlm.addElement(user);
            }
            this.userList = new JList(dlm);
            this.userList.setSelectionMode(2);
            final ListCellRenderer renderer = this.userList.getCellRenderer();
            this.userList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object nValue = value;
                    boolean active = true;
                    if (nValue instanceof Webportal.User) {
                        Webportal.User user = (Webportal.User)nValue;
                        StringBuilder sb = new StringBuilder(user.getLogin());
                        if (user.hasName()) {
                            sb.append(" - ").append(user.getName());
                        }
                        if (user.hasCustomerNumber()) {
                            sb.append(" - ").append(user.getCustomerNumber());
                        }
                        nValue = sb.toString();
                        active = !user.hasActive() || user.getActive();
                    }
                    Component comp = renderer.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
                    if (!active) {
                        comp.setForeground(comp.getForeground().brighter());
                    }
                    return comp;
                }
            });
            panel.add((Component)new JScrollPane(this.userList), "Center");
            JPanel buttonPanel = new JPanel(new BorderLayout());
            JPanel subButtonPanel = new JPanel(new FlowLayout());
            this.editUserAction = new EditUserAction();
            subButtonPanel.add(new JButton(this.editUserAction));
            this.editUserAction.setEnabled(false);
            this.userList.addListSelectionListener(new UserListSelectionListener());
            subButtonPanel.add(new JButton(new AddUserAction()));
            subButtonPanel.add(new JButton(new UpdateUserAction()));
            buttonPanel.add((Component)subButtonPanel, "East");
            panel.add((Component)buttonPanel, "South");
        }
        catch (WebportalException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        return panel;
    }

    private JPanel createOrderPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.webportal.orders", new Serializable[0]));
        panel.add((Component)label, "North");
        try {
            byte[] orderByteArray = this.modelEnviroment.getAllCaller().getWebportalCaller().createWebportalOrdersAndGetAll(this.webportalName);
            Webportal.OrderList orders = Webportal.OrderList.parseFrom(orderByteArray);
            DefaultListModel<Webportal.Order> dlm = new DefaultListModel<Webportal.Order>();
            for (Webportal.Order order : orders.getOrdersList()) {
                dlm.addElement(order);
            }
            this.orderList = new JList(dlm);
            this.orderList.setSelectionMode(2);
            final ListCellRenderer renderer = this.orderList.getCellRenderer();
            this.orderList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object nValue = value;
                    if (value instanceof Webportal.Order) {
                        nValue = ((Webportal.Order)value).getOrderNumber();
                    }
                    return renderer.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
                }
            });
            panel.add((Component)new JScrollPane(this.orderList), "Center");
            JPanel buttonPanel = new JPanel(new BorderLayout());
            JButton update = new JButton(new DeleteOrderAction());
            buttonPanel.add((Component)update, "East");
            panel.add((Component)buttonPanel, "South");
            return panel;
        }
        catch (WebportalException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkLogins() {
        DefaultListModel dlm = (DefaultListModel)this.userList.getModel();
        LinkedHashMap loginMap = new LinkedHashMap();
        boolean found = false;
        for (int i = 0; i < dlm.getSize(); ++i) {
            void var7_9;
            Webportal.User user = (Webportal.User)dlm.elementAt(i);
            String login = user.getLogin();
            List list = (List)loginMap.get(login);
            if (list == null) {
                LinkedList linkedList = new LinkedList();
            } else {
                found = true;
            }
            var7_9.add(user);
        }
        if (found) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry entry : loginMap.entrySet()) {
                List list = (List)entry.getValue();
                int size = list.size();
                if (size <= 1) continue;
                if (!first) {
                    sb.append("\n");
                }
                first = false;
                Object[] names = new String[size];
                int i = 0;
                for (Webportal.User user : list) {
                    names[i] = user.getName();
                    ++i;
                }
                sb.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.webportalcontrol.multipleUser", new Serializable[]{(Serializable)entry.getKey(), StringUtil.implode(names, ", ")}));
            }
            JTextArea textArea = new JTextArea(sb.toString());
            textArea.setEditable(false);
            JOptionPane.showMessageDialog(this, new JScrollPane(textArea), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
        }
        return !found;
    }

    private class UserListSelectionListener
    implements ListSelectionListener {
        private UserListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            WebportalControlDialog.this.editUserAction.setEnabled(!WebportalControlDialog.this.userList.isSelectionEmpty());
        }
    }

    private class DeleteOrderAction
    extends AbstractAction {
        public DeleteOrderAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedValues = WebportalControlDialog.this.orderList.getSelectedValues();
            HashSet<String> orderNumbers = new HashSet<String>();
            for (Object o : selectedValues) {
                orderNumbers.add(((Webportal.Order)o).getOrderNumber());
            }
            try {
                WebportalControlDialog.this.modelEnviroment.getAllCaller().getWebportalCaller().deleteOrders(orderNumbers, WebportalControlDialog.this.webportalName);
                DefaultListModel dlm = (DefaultListModel)WebportalControlDialog.this.orderList.getModel();
                for (Object o : selectedValues) {
                    dlm.removeElement(o);
                }
            }
            catch (WebportalException ex) {
                BufferedImage image;
                try {
                    image = ImageIO.read(WebportalControlDialog.class.getResourceAsStream("/images/pepper.png"));
                }
                catch (IOException ioEx) {
                    throw new RuntimeException(ioEx);
                }
                ExceptionMessageDialog errorMessageDialog = new ExceptionMessageDialog((Window)WebportalControlDialog.this, ex, image);
                errorMessageDialog.setVisible(true);
            }
        }
    }

    private class AddUserAction
    extends AbstractAction {
        private static final long serialVersionUID = 1525021546163814130L;

        public AddUserAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserEditDialog userEditDialog = new UserEditDialog(WebportalControlDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0])){
                private static final long serialVersionUID = 1740083575404069012L;

                @Override
                protected void doAfterOk() {
                    Webportal.User user = this.getUser();
                    DefaultListModel dlm = (DefaultListModel)WebportalControlDialog.this.userList.getModel();
                    dlm.addElement(user);
                }
            };
            userEditDialog.setVisible(true);
        }
    }

    private class EditUserAction
    extends AbstractAction {
        private static final long serialVersionUID = 7954469206824761518L;

        public EditUserAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Webportal.User user = (Webportal.User)WebportalControlDialog.this.userList.getSelectedValue();
            UserEditDialog userEditDialog = new UserEditDialog(WebportalControlDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]), user){
                private static final long serialVersionUID = 1740083575404069012L;

                @Override
                protected void doAfterOk() {
                    Webportal.User user = this.getUser();
                    DefaultListModel dlm = (DefaultListModel)WebportalControlDialog.this.userList.getModel();
                    dlm.setElementAt(user, WebportalControlDialog.this.userList.getSelectedIndex());
                }
            };
            userEditDialog.setVisible(true);
        }
    }

    private class UpdateUserAction
    extends AbstractAction {
        private static final long serialVersionUID = 7954469206824761518L;

        public UpdateUserAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.update", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WebportalControlDialog.this.checkLogins()) {
                Webportal.UserList.Builder builder = Webportal.UserList.newBuilder();
                DefaultListModel dlm = (DefaultListModel)WebportalControlDialog.this.userList.getModel();
                for (int i = 0; i < dlm.getSize(); ++i) {
                    builder.addUsers((Webportal.User)dlm.elementAt(i));
                }
                try {
                    WebportalControlDialog.this.modelEnviroment.getAllCaller().getWebportalCaller().updateUsers(builder.build().toByteArray(), WebportalControlDialog.this.webportalName);
                    JOptionPane.showMessageDialog(WebportalControlDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.webportal.updateUsers.report", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
                }
                catch (WebportalException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private class UploadAreaAction
    extends AbstractAction {
        private static final long serialVersionUID = -8903630367415183073L;

        public UploadAreaAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.webportalcontrol.uploadAreas", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                WebportalUploadAreasReportDto reportDto = WebportalControlDialog.this.modelEnviroment.getAllCaller().getWebportalCaller().uploadAreas(WebportalControlDialog.this.webportalName);
                JOptionPane.showMessageDialog(WebportalControlDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.webportal.uploadAreas.report", reportDto.getCount()), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
            }
            catch (WebportalException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

