/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.parameter;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.DefaultAreaObjectChooserPane;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.model.wage.WageParameterModelImpl;
import de.datomino.peppergis.client.util.wage.WageDeltaModelUtil;
import de.datomino.peppergis.client.wage.parameter.WageParameterPane;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.type.WageParameterStatus;
import de.datomino.peppergis.wage.parameter.WageParameterListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WageParameterConfigrationDialog
extends CommonDialog {
    private static final long serialVersionUID = 1312594156979902860L;
    private static final String DEFAULT_NEW_NAME = ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.newParameter", new Serializable[0]);
    private ModelEnviroment modelEnviroment;
    private JList parameterList;
    private DefaultListModel parameterListModel;
    private AddParameterAction addLayerAction = new AddParameterAction();
    private DeleteAction deleteLayerAction = new DeleteAction();
    private DuplicateAction duplicateLayerAction = new DuplicateAction();
    private WageParameterPane editPanel;
    private DefaultAreaObjectChooserPane areaObjectChooserPane;
    private Map<AreaLayerModel, Map<AreaObjectModel, WageParameterModel>> modelMapForSelection = new HashMap<AreaLayerModel, Map<AreaObjectModel, WageParameterModel>>();

    public WageParameterConfigrationDialog(Component parent, ModelEnviroment modelEnviroment) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.config", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.pack();
        this.center();
        this.fillData();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.modelEnviroment.getUndoManager().finishTransaction("");
            this.modelEnviroment.getUndoManager().startTransaction();
        }
        super.setVisible(b);
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 3280449595070962158L;

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Map value : WageParameterConfigrationDialog.this.modelMapForSelection.values()) {
                    for (AreaObjectModel area : value.keySet()) {
                        WageParameterModel oldPara = area.getWageParameter();
                        WageParameterModel newPara = (WageParameterModel)value.get(area);
                        if (!(oldPara == null || newPara != null && oldPara.equals(newPara))) {
                            area.setWageParameter(newPara);
                            continue;
                        }
                        if (oldPara != null || newPara == null) continue;
                        area.setWageParameter(newPara);
                    }
                }
                UndoManager undoManager = WageParameterConfigrationDialog.this.modelEnviroment.getUndoManager();
                undoManager.finishTransaction("Parameter Konfiguration");
                try {
                    undoManager.storeTransactions();
                    WageParameterConfigrationDialog.this.dispose();
                }
                catch (ValidateException ex) {
                    undoManager.handleValidateException(ex);
                }
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new DialogDisposeAction(this){
            private static final long serialVersionUID = 1146142451302388061L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = WageParameterConfigrationDialog.this.modelEnviroment.getUndoManager();
                undoManager.rollbackTransaction();
                WageParameterConfigrationDialog.this.parameterList.setSelectedIndex(0);
                WageParameterConfigrationDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JSplitPane panel = new JSplitPane(1);
        panel.setLeftComponent(this.createParameterListPanel());
        panel.setRightComponent(this.createCommonEditPanel());
        return panel;
    }

    private Component createCommonEditPanel() {
        this.editPanel = new WageParameterPane(null, true, this.modelEnviroment);
        this.editPanel.setEnabled(false);
        JPanel areaObjectPane = new JPanel(new BorderLayout());
        AreaObjectGenInfoDiscriminator[] ds = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND};
        final AreaLayerComboBox layerComboBox = new AreaLayerComboBox(this.modelEnviroment, false, ds, false, true);
        layerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WageParameterConfigrationDialog.this.fireAreaLayerChange(layerComboBox, true);
                }
            }
        });
        this.areaObjectChooserPane = new DefaultAreaObjectChooserPane((AreaLayerModel)layerComboBox.getItemAt(0), this.modelEnviroment, false){
            private static final long serialVersionUID = -5269281459721221853L;

            @Override
            protected void fireMarkAreaCell(String shortCut, boolean selected) {
                Map map = (Map)WageParameterConfigrationDialog.this.modelMapForSelection.get(WageParameterConfigrationDialog.this.areaObjectChooserPane.getAreaLayerModel());
                AreaObjectModel found = null;
                for (AreaObjectModel areaObject : map.keySet()) {
                    if (!areaObject.getShortcut().equals(shortCut)) continue;
                    found = areaObject;
                    break;
                }
                if (found != null) {
                    map.put(found, selected ? WageParameterConfigrationDialog.this.editPanel.getWageParameter() : null);
                }
            }

            @Override
            protected void fireShowAll(boolean selected) {
                WageParameterModel wageParameter = WageParameterConfigrationDialog.this.editPanel.getWageParameter();
                AreaLayerModel areaLayer = WageParameterConfigrationDialog.this.areaObjectChooserPane.getAreaLayerModel();
                Map map = (Map)WageParameterConfigrationDialog.this.modelMapForSelection.get(areaLayer);
                if (wageParameter != null && map != null) {
                    int setNull = -1;
                    if (!selected) {
                        setNull = JOptionPane.showConfirmDialog(WageParameterConfigrationDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.parameter.setNull", new Serializable[0]), "", 0);
                    }
                    HashMap<AreaObjectModel, WageParameterModel> changed = new HashMap<AreaObjectModel, WageParameterModel>();
                    block3: for (AreaObjectModel areaObject : map.keySet()) {
                        if (selected) {
                            changed.put(areaObject, wageParameter);
                            continue;
                        }
                        switch (setNull) {
                            case 0: {
                                changed.put(areaObject, null);
                                continue block3;
                            }
                        }
                        changed.put(areaObject, (WageParameterModel)map.get(areaObject));
                    }
                    WageParameterConfigrationDialog.this.modelMapForSelection.put(areaLayer, changed);
                    WageParameterConfigrationDialog.this.fireAreaLayerChange(layerComboBox, false);
                }
            }

            @Override
            protected String getShowAllMessageKey() {
                return "messages.area.selectAll";
            }
        };
        areaObjectPane.add((Component)layerComboBox, "North");
        areaObjectPane.add((Component)this.areaObjectChooserPane, "Center");
        this.parameterList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WageParameterModel wageParameter;
                WageParameterModel selectedValue = (WageParameterModel)WageParameterConfigrationDialog.this.parameterList.getSelectedValue();
                if (selectedValue == null) {
                    WageParameterConfigrationDialog.this.editPanel.setWageParameter(null);
                    WageParameterConfigrationDialog.this.editPanel.setEnabled(false);
                    return;
                }
                if (layerComboBox.getModel().getSize() > 0) {
                    layerComboBox.setSelectedIndex(0);
                    WageParameterConfigrationDialog.this.fireAreaLayerChange(layerComboBox, true);
                }
                if ((wageParameter = WageParameterConfigrationDialog.this.editPanel.getWageParameter()) == null || !wageParameter.equals(selectedValue)) {
                    WageParameterConfigrationDialog.this.modelEnviroment.getUndoManager().startTransaction();
                    WageParameterConfigrationDialog.this.editPanel.setWageParameter(selectedValue);
                    WageParameterConfigrationDialog.this.pack();
                    WageParameterConfigrationDialog.this.editPanel.setEnabled(true);
                }
            }
        });
        return this.editPanel;
    }

    private JPanel createParameterListPanel() {
        JPanel listPanel = new JPanel(new BorderLayout());
        this.parameterListModel = new DefaultListModel();
        this.parameterList = new JList(this.parameterListModel);
        this.parameterList.setCellRenderer(new WageParameterListCellRenderer());
        JScrollPane scroll = new JScrollPane(this.parameterList);
        listPanel.add((Component)scroll, "Center");
        this.parameterList.setSelectionMode(0);
        JPanel listButtonPanel = new JPanel(new FlowLayout());
        JButton addButton = new JButton(this.addLayerAction);
        listButtonPanel.add(addButton);
        listButtonPanel.add(new JButton(this.duplicateLayerAction));
        JButton deleteButton = new JButton(this.deleteLayerAction);
        listButtonPanel.add(deleteButton);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)listButtonPanel, "East");
        listPanel.add((Component)buttonPanel, "South");
        listPanel.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.parameter", new Serializable[0])));
        return listPanel;
    }

    private void fillData() {
        WageParameterStatus[] statuses = new WageParameterStatus[]{WageParameterStatus.ACTIVE, WageParameterStatus.DEFAULT};
        Collection<WageParameterModel> parameterModels = this.modelEnviroment.getAllCaller().getWageCaller().fetchWageParameterWithStatus(statuses);
        this.parameterListModel.clear();
        int countDefaultParameter = 0;
        for (WageParameterModel parameterModel : parameterModels) {
            if (parameterModel.getStatus() == WageParameterStatus.DEFAULT) {
                ++countDefaultParameter;
            }
            this.parameterListModel.addElement(parameterModel);
        }
        switch (countDefaultParameter) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "Mehrfach Standard-Parameters", ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
            }
        }
    }

    private String getNewParameterName(String defaultName) {
        boolean found;
        String newName = defaultName;
        int suffixCount = 1;
        int size = this.parameterListModel.getSize();
        block0: do {
            found = true;
            for (int i = 0; i < size; ++i) {
                WageParameterModel element = (WageParameterModel)this.parameterListModel.getElementAt(i);
                if (!element.getName().equals(newName)) continue;
                newName = defaultName + "_" + suffixCount;
                ++suffixCount;
                found = false;
                continue block0;
            }
        } while (!found);
        return newName;
    }

    private void fireAreaLayerChange(AreaLayerComboBox layerComboBox, boolean clear) {
        WageParameterModel wageParameter;
        AreaLayerModel areaLayer = (AreaLayerModel)layerComboBox.getSelectedItem();
        if (clear) {
            this.areaObjectChooserPane.setAreaLayerModel(areaLayer);
            this.areaObjectChooserPane.clearSelection();
        }
        if ((wageParameter = this.editPanel.getWageParameter()) != null) {
            Map<AreaObjectModel, WageParameterModel> map = this.modelMapForSelection.get(areaLayer);
            if (map == null) {
                map = new HashMap<AreaObjectModel, WageParameterModel>();
                this.modelMapForSelection.put(areaLayer, map);
                List<AreaObjectModel> areaObjects = this.modelEnviroment.getAllCaller().getAreaCaller().fetchAreaObjectsByAreaLayer(areaLayer, false);
                for (AreaObjectModel areaObject : areaObjects) {
                    map.put(areaObject, areaObject.getWageParameter());
                }
            }
            HashSet<String> shortcuts = new HashSet<String>();
            for (AreaObjectModel area : map.keySet()) {
                if (map.get(area) == null || !map.get(area).equals(wageParameter)) continue;
                shortcuts.add(area.getShortcut());
            }
            this.areaObjectChooserPane.setSelection(shortcuts);
        }
        this.pack();
    }

    private class DuplicateAction
    extends AbstractAction {
        private static final long serialVersionUID = -7809468279229357826L;

        public DuplicateAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.duplicate", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER, UserRole.WAGE_ACTIVE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WageParameterModel para = WageParameterConfigrationDialog.this.editPanel.getWageParameter();
            if (para != null) {
                int size = WageParameterConfigrationDialog.this.parameterListModel.getSize();
                WageParameterModelImpl newPara = new WageParameterModelImpl();
                WageDeltaModelUtil.wageParameterClone(para, newPara);
                newPara.setStatus(WageParameterStatus.ACTIVE);
                String newName = WageParameterConfigrationDialog.this.getNewParameterName(para.getName());
                newPara.setName(newName);
                WageParameterConfigrationDialog.this.modelEnviroment.getUndoManager().finishTransaction("Duplizieren Parameter - " + para.getName());
                WageParameterConfigrationDialog.this.modelEnviroment.getUndoManager().startTransaction();
                WageParameterConfigrationDialog.this.parameterListModel.addElement(newPara);
                WageParameterConfigrationDialog.this.parameterList.setSelectedIndex(size);
                WageParameterConfigrationDialog.this.areaObjectChooserPane.clearSelection();
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -4404522613147625021L;

        public DeleteAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER, UserRole.WAGE_ACTIVE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int d;
            WageParameterModel para = WageParameterConfigrationDialog.this.editPanel.getWageParameter();
            if (para != null && (d = JOptionPane.showConfirmDialog(WageParameterConfigrationDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.delete.confirmDeleteAlert", new Serializable[]{para.getName()}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]), 2, 2)) == 0) {
                para.setStatus(WageParameterStatus.INACTIVE);
                WageParameterConfigrationDialog.this.modelEnviroment.getUndoManager().finishTransaction("L\u00f6schen Parameter - " + para.getName());
                WageParameterConfigrationDialog.this.modelEnviroment.getUndoManager().startTransaction();
                WageParameterConfigrationDialog.this.parameterListModel.removeElement(para);
                WageParameterConfigrationDialog.this.editPanel.setWageParameter(null);
            }
        }
    }

    private class AddParameterAction
    extends AbstractAction {
        private static final long serialVersionUID = 6054447898358703308L;

        public AddParameterAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER, UserRole.WAGE_ACTIVE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int size = WageParameterConfigrationDialog.this.parameterListModel.getSize();
            WageParameterModelImpl newPara = new WageParameterModelImpl();
            newPara.setName(WageParameterConfigrationDialog.this.getNewParameterName(DEFAULT_NEW_NAME));
            newPara.setBack(false);
            newPara.setStatus(WageParameterStatus.ACTIVE);
            WageParameterConfigrationDialog.this.modelEnviroment.getUndoManager().finishTransaction("Anlegen Parameter - " + newPara.getName());
            WageParameterConfigrationDialog.this.modelEnviroment.getUndoManager().startTransaction();
            WageParameterConfigrationDialog.this.parameterListModel.addElement(newPara);
            WageParameterConfigrationDialog.this.parameterList.setSelectedIndex(size);
        }
    }
}

